/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.AlertEvent;
import org.qubership.atp.environments.repo.impl.AlertEventRepositoryImpl;
import org.qubership.atp.environments.service.direct.AlertEventService;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="alertEventService")
public class AlertEventServiceImpl
implements AlertEventService {
    private final AlertEventRepositoryImpl alertEventRepository;
    private final DateTimeUtil dateTimeUtil;

    @Autowired
    public AlertEventServiceImpl(AlertEventRepositoryImpl alertEventRepository, DateTimeUtil dateTimeUtil) {
        this.alertEventRepository = alertEventRepository;
        this.dateTimeUtil = dateTimeUtil;
    }

    @Override
    @Nullable
    public AlertEvent get(@Nonnull UUID alertId, @Nonnull UUID entityId) {
        return this.alertEventRepository.getById(alertId, entityId);
    }

    @Override
    @Nonnull
    public List<AlertEvent> getAll() {
        return this.alertEventRepository.getAll();
    }

    @Override
    @Nonnull
    public AlertEvent create(@Nonnull UUID alertId, UUID entityId, String tagList, Integer status) {
        return this.alertEventRepository.create(alertId, entityId, tagList, status, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    public void update(@Nonnull UUID alertId, UUID entityId, String tagList, Integer status) {
        this.alertEventRepository.update(alertId, entityId, tagList, status, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    public void delete(@Nonnull UUID alertId, UUID entityId) {
        this.alertEventRepository.delete(alertId, entityId);
    }
}

