/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.environments.model.CreatedModified;
import org.qubership.atp.environments.service.direct.ConcurrentModificationService;
import org.qubership.atp.environments.service.direct.IdentifiedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ConcurrentModificationServiceImpl
implements ConcurrentModificationService {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentModificationServiceImpl.class);

    @Override
    public <T extends CreatedModified> HttpStatus getConcurrentModificationHttpStatus(@Nonnull UUID entityId, Long modifiedFromRequest, @Nonnull IdentifiedService<T> service) {
        CreatedModified entity = (CreatedModified)service.get(entityId);
        if (entity != null) {
            Long modifiedFromDB = entity.getModified();
            if (modifiedFromRequest != null && !modifiedFromRequest.equals(modifiedFromDB)) {
                log.info("Concurrent modification detected. Returning HTTP-status: 226 - Im used. Modified from request: {}, modified from database: {}", (Object)modifiedFromRequest, (Object)modifiedFromDB);
                return HttpStatus.IM_USED;
            }
        }
        return HttpStatus.OK;
    }
}

