/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.EnvironmentCategory;
import org.qubership.atp.environments.repo.impl.EnvironmentCategoryRepositoryImpl;
import org.qubership.atp.environments.service.direct.EnvironmentCategoryService;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="environmentCategoryService")
public class EnvironmentCategoryServiceImpl
implements EnvironmentCategoryService {
    private final EnvironmentCategoryRepositoryImpl environmentCategoryRepository;
    private final DateTimeUtil dateTimeUtil;

    @Autowired
    public EnvironmentCategoryServiceImpl(EnvironmentCategoryRepositoryImpl environmentCategoryRepository, DateTimeUtil dateTimeUtil) {
        this.environmentCategoryRepository = environmentCategoryRepository;
        this.dateTimeUtil = dateTimeUtil;
    }

    @Override
    @Nullable
    public EnvironmentCategory get(@Nonnull UUID id) {
        return this.environmentCategoryRepository.getById(id);
    }

    @Override
    public boolean existsById(@Nonnull UUID id) {
        return this.environmentCategoryRepository.existsById(id);
    }

    @Override
    @Nonnull
    public List<EnvironmentCategory> getAll() {
        return this.environmentCategoryRepository.getAll();
    }

    @Override
    @Nonnull
    public EnvironmentCategory create(String name, String description, String tagList) {
        return this.environmentCategoryRepository.create(name, description, tagList, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    @Nonnull
    public EnvironmentCategory update(UUID id, String name, String description, String tagList) {
        return this.environmentCategoryRepository.update(id, name, description, tagList, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    public void delete(UUID id) {
        this.environmentCategoryRepository.delete(id);
    }
}

