/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.Subscriber;
import org.qubership.atp.environments.model.Subscription;
import org.qubership.atp.environments.repo.impl.SubscriberRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SubscriptionRepositoryImpl;
import org.qubership.atp.environments.service.direct.SubscriberService;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subscriberService")
public class SubscriberServiceImpl
implements SubscriberService {
    private final SubscriberRepositoryImpl subscriberRepository;
    private final SubscriptionRepositoryImpl subscriptionRepository;
    private final DateTimeUtil dateTimeUtil;

    @Autowired
    public SubscriberServiceImpl(SubscriberRepositoryImpl subscriberRepository, SubscriptionRepositoryImpl subscriptionRepository, DateTimeUtil dateTimeUtil) {
        this.subscriberRepository = subscriberRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.dateTimeUtil = dateTimeUtil;
    }

    @Override
    @Nullable
    public Subscriber get(@Nonnull UUID id) {
        return this.subscriberRepository.getById(id);
    }

    @Override
    public boolean existsById(@Nonnull UUID id) {
        return this.subscriberRepository.existsById(id);
    }

    @Override
    @Nonnull
    public List<Subscriber> getAll() {
        return this.subscriberRepository.getAll();
    }

    @Override
    @Nonnull
    public Subscriber create(Subscriber subscriber) {
        return this.subscriberRepository.create(subscriber.getName(), subscriber.getHost(), subscriber.getSubscriberType(), subscriber.getSignature(), subscriber.getTagList(), subscriber.getHostStatus(), subscriber.getNotificationURL(), this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    public void update(Subscriber subscriber) {
        this.subscriberRepository.update(subscriber.getId(), subscriber.getName(), subscriber.getHost(), subscriber.getSubscriberType(), subscriber.getSignature(), subscriber.getTagList(), subscriber.getHostStatus(), subscriber.getNotificationURL(), this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    public void delete(UUID subscriberId) {
        this.subscriberRepository.delete(subscriberId);
    }

    @Override
    public List<Subscription> getSubscriptions(UUID subscriberId) {
        return this.subscriptionRepository.getAllByParentId(subscriberId);
    }
}

