/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.SystemCategory;
import org.qubership.atp.environments.repo.impl.SystemCategoryRepositoryImpl;
import org.qubership.atp.environments.service.direct.SystemCategoriesService;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="systemCategoriesService")
public class SystemCategoriesServiceImpl
implements SystemCategoriesService {
    private final SystemCategoryRepositoryImpl systemCategoriesRepository;
    private final DateTimeUtil dateTimeUtil;

    @Autowired
    public SystemCategoriesServiceImpl(SystemCategoryRepositoryImpl systemCategoriesRepository, DateTimeUtil dateTimeUtil) {
        this.systemCategoriesRepository = systemCategoriesRepository;
        this.dateTimeUtil = dateTimeUtil;
    }

    @Override
    @Nullable
    public SystemCategory get(@Nonnull UUID id) {
        return this.systemCategoriesRepository.getById(id);
    }

    @Override
    public boolean existsById(@Nonnull UUID id) {
        return this.systemCategoriesRepository.existsById(id);
    }

    @Override
    @Nonnull
    public List<SystemCategory> getAll() {
        return this.systemCategoriesRepository.getAll();
    }

    @Override
    @Nonnull
    public SystemCategory create(String name, String description) {
        return this.systemCategoriesRepository.create(name, description, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    @Nonnull
    public SystemCategory update(UUID id, String name, String description) {
        return this.systemCategoriesRepository.update(id, name, description, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    public void delete(UUID id) {
    }

    @Override
    public SystemCategory getByName(String name) {
        return this.systemCategoriesRepository.getByName(name);
    }
}

