/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.openshift.restclient.model.route.IRoute;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.environments.enums.MdcField;
import org.qubership.atp.environments.errorhandling.clients.EnvironmentCloudClientCreationException;
import org.qubership.atp.environments.errorhandling.clients.EnvironmentIllegalCloudConnectionTemplateClassException;
import org.qubership.atp.environments.errorhandling.clients.EnvironmentOpenshiftProjectFetchException;
import org.qubership.atp.environments.helper.JsonPathHandler;
import org.qubership.atp.environments.helper.RegexpHandler;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.model.ParametersGettingVersion;
import org.qubership.atp.environments.model.ServerItf;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.SystemCategory;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.model.utils.enums.Status;
import org.qubership.atp.environments.repo.impl.ConnectionRepositoryImpl;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.qubership.atp.environments.service.direct.ConnectionService;
import org.qubership.atp.environments.service.direct.DecryptorService;
import org.qubership.atp.environments.service.direct.EncryptorService;
import org.qubership.atp.environments.service.direct.KafkaService;
import org.qubership.atp.environments.service.direct.SystemCategoriesService;
import org.qubership.atp.environments.service.direct.SystemService;
import org.qubership.atp.environments.service.direct.impl.MetricService;
import org.qubership.atp.environments.service.rest.server.dto.ConnectionDto;
import org.qubership.atp.environments.service.rest.server.dto.CreateSystemDto;
import org.qubership.atp.environments.service.rest.server.dto.EventType;
import org.qubership.atp.environments.service.rest.server.dto.SharingRequestDto;
import org.qubership.atp.environments.service.rest.server.dto.StatusDto;
import org.qubership.atp.environments.service.rest.server.dto.SystemDto;
import org.qubership.atp.environments.service.rest.server.response.ShortExternalService;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.qubership.atp.environments.utils.cloud.ExternalCloudClient;
import org.qubership.atp.environments.utils.cloud.KubeClient;
import org.qubership.atp.environments.utils.cloud.OpenshiftClient;
import org.qubership.atp.environments.utils.cloud.model.CloudService;
import org.qubership.atp.environments.version.checkers.VersionChecker;
import org.qubership.atp.environments.version.checkers.VersionCheckerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="systemService")
public class SystemServiceImpl
implements SystemService {
    private static final Logger log = LoggerFactory.getLogger(SystemServiceImpl.class);
    @Value(value="${atp-environments.regexp.timeout}")
    private int regexpTimeout;
    private final SystemRepositoryImpl systemRepository;
    private final ConnectionRepositoryImpl connectionRepository;
    private final ConnectionService connectionService;
    private final SystemCategoriesService systemCategoriesService;
    private final EnvironmentRepositoryImpl environmentRepository;
    private final DateTimeUtil dateTimeUtil;
    private final EncryptorService encryptorService;
    private final DecryptorService decryptorService;
    private final Provider<UserInfo> userInfoProvider;
    private final RegexpHandler regexpHandler;
    private final JsonPathHandler jsonPathHandler;
    private final KafkaService kafkaService;
    private final VersionCheckerFactory versionCheckerFactory;
    private final MetricService metricService;
    @Lazy
    @Autowired
    private SystemService ref;

    @Autowired
    public SystemServiceImpl(SystemRepositoryImpl systemRepository, ConnectionRepositoryImpl connectionRepository, ConnectionService connectionService, SystemCategoriesService systemCategoriesService, DateTimeUtil dateTimeUtil, EnvironmentRepositoryImpl environmentRepository, EncryptorService encryptorService, DecryptorService decryptorService, Provider<UserInfo> userInfoProvider, KafkaService kafkaService, RegexpHandler regexpHandler, JsonPathHandler jsonPathHandler, VersionCheckerFactory versionCheckerFactory, MetricService metricService) {
        this.systemRepository = systemRepository;
        this.connectionRepository = connectionRepository;
        this.connectionService = connectionService;
        this.systemCategoriesService = systemCategoriesService;
        this.environmentRepository = environmentRepository;
        this.dateTimeUtil = dateTimeUtil;
        this.encryptorService = encryptorService;
        this.decryptorService = decryptorService;
        this.userInfoProvider = userInfoProvider;
        this.regexpHandler = regexpHandler;
        this.jsonPathHandler = jsonPathHandler;
        this.kafkaService = kafkaService;
        this.versionCheckerFactory = versionCheckerFactory;
        this.metricService = metricService;
    }

    @Override
    @Nullable
    public System get(@Nonnull UUID id) {
        return this.systemRepository.getById(id);
    }

    @Override
    public boolean existsById(@Nonnull UUID id) {
        return this.systemRepository.existsById(id);
    }

    @Override
    public System getV2(@Nonnull UUID id) {
        return this.systemRepository.getByIdV2(id);
    }

    @Override
    public List<System> getAll() {
        return this.systemRepository.getAll();
    }

    @Override
    @Transactional
    public System replicate(@Nonnull UUID environmentId, @Nonnull UUID systemId, @Nonnull String name, String description, UUID systemCategoryId, ParametersGettingVersion parametersGettingVersion, UUID parentSystemId, ServerItf serverItf, UUID linkToSystemId, UUID externalId, UUID sourceId, String externalName) {
        this.systemRepository.getContext().setFullDbFetching(true);
        String trimmedSystemName = name.trim();
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        return this.systemRepository.create(environmentId, systemId, trimmedSystemName, description, this.dateTimeUtil.timestampAsUtc(), userId, systemCategoryId, parametersGettingVersion, parentSystemId, serverItf, false, linkToSystemId, externalId, sourceId, externalName);
    }

    @Override
    @Transactional
    public System create(UUID environmentId, String name, String description, UUID systemCategoryId, ParametersGettingVersion parametersGettingVersion, UUID parentSystemId, ServerItf serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, String externalName) {
        this.systemRepository.getContext().setFullDbFetching(true);
        String trimmedSystemName = name.trim();
        Preconditions.checkArgument((boolean)this.systemRepository.checkSystemNameIsUniqueUnderEnvironment(environmentId, trimmedSystemName).isEmpty(), (String)"System with name \"%s\" already exists under environment", (Object)trimmedSystemName);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        return this.systemRepository.create(environmentId, trimmedSystemName, description, this.dateTimeUtil.timestampAsUtc(), userId, systemCategoryId, parametersGettingVersion, parentSystemId, serverItf, mergeByName, linkToSystemId, externalId, externalName);
    }

    @Override
    @Transactional
    public Connection create(UUID systemId, ConnectionDto connection) {
        this.systemRepository.getContext().setFullDbFetching(true);
        UUID sourceTemplateId = connection.getSourceTemplateId();
        if (sourceTemplateId != null) {
            Connection sourceId = this.connectionRepository.getById(sourceTemplateId);
            Preconditions.checkNotNull((Object)sourceId, (String)"Wrong sourceTemplateId: %s", (Object)sourceTemplateId);
        }
        return this.connectionService.replicate(systemId, connection.getId(), connection.getName(), connection.getDescription(), connection.getParameters(), connection.getConnectionType(), connection.getSourceTemplateId(), connection.getServices(), null);
    }

    @Override
    @Nonnull
    @Transactional
    public System create(UUID environmentId, CreateSystemDto system) {
        this.systemRepository.getContext().setFullDbFetching(true);
        UUID systemCategoryId = system.getSystemCategoryId();
        if (systemCategoryId != null) {
            SystemCategory systemCategory = (SystemCategory)this.systemCategoriesService.get(systemCategoryId);
            Preconditions.checkNotNull((Object)systemCategory, (String)"Wrong categoryId: %s", (Object)systemCategoryId);
        }
        System result = this.create(environmentId, system.getName(), system.getDescription(), systemCategoryId, system.getParametersGettingVersion(), system.getParentSystemId(), system.getServerItf(), system.getMergeByName(), system.getLinkToSystemId(), system.getExternalId(), system.getExternalName());
        List connection = system.getConnections().stream().map(connectionDto -> this.create(result.getId(), (ConnectionDto)connectionDto)).collect(Collectors.toList());
        result.setConnections(connection);
        return result;
    }

    @Override
    @Transactional
    public System copy(UUID id, UUID environmentId, String name, String description, UUID systemCategoryId, ParametersGettingVersion parametersGettingVersion, UUID parentSystemId, ServerItf serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, String externalName) {
        this.systemRepository.getContext().setFullDbFetching(true);
        System toCopy = this.systemRepository.getById(id);
        System newSys = this.create(environmentId, name, description, systemCategoryId, parametersGettingVersion, parentSystemId, serverItf, mergeByName, linkToSystemId, externalId, externalName);
        if (toCopy.getConnections() != null) {
            newSys.setConnections(new ArrayList());
            toCopy.getConnections().forEach(connection -> newSys.getConnections().add(this.connectionService.create(newSys.getId(), connection.getName(), connection.getDescription(), connection.getParameters(), connection.getConnectionType(), connection.getSourceTemplateId(), connection.getServices())));
        }
        return newSys;
    }

    @Override
    @Transactional
    @CacheEvict(value={"ATP_ENVIRONMENTS-ENVIRONMENTS_BY_SYSTEM_ID"}, key="#systemId", condition=" #systemId != null && (!#sharingRequestDto.getShareList().isEmpty() || !#sharingRequestDto.getUnShareList().isEmpty())")
    public System shareProcessing(UUID systemId, SharingRequestDto sharingRequestDto) {
        System sharedSystem = this.systemRepository.getById(systemId);
        sharedSystem = this.share(sharedSystem, sharingRequestDto.getShareList());
        sharedSystem = this.unShare(sharedSystem.getId(), sharingRequestDto.getUnShareList());
        return sharedSystem;
    }

    @Override
    @Transactional
    public System share(System sharedSystem, List<UUID> environmentIds) {
        this.systemRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        System returnedSystem = sharedSystem;
        for (UUID environmentId : environmentIds) {
            Environment environment = this.environmentRepository.getById(environmentId);
            Preconditions.checkArgument((boolean)this.systemRepository.checkSystemNameIsUniqueUnderEnvironment(environmentId, sharedSystem.getName()).isEmpty(), (String)"System with name \"%s\" already exists under environment \"%s\"", (Object)sharedSystem.getName(), (Object)environment.getName());
            returnedSystem = this.systemRepository.share(sharedSystem.getId(), environment, this.dateTimeUtil.timestampAsUtc(), userId);
        }
        return returnedSystem == null ? this.get(sharedSystem.getId()) : returnedSystem;
    }

    @Override
    @Transactional
    public System unShare(UUID systemId, List<UUID> environmentIds) {
        this.systemRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        System returnedSystem = null;
        for (UUID environmentId : environmentIds) {
            returnedSystem = this.systemRepository.unShare(systemId, environmentId, this.dateTimeUtil.timestampAsUtc(), userId);
        }
        return returnedSystem == null ? this.get(systemId) : returnedSystem;
    }

    @Override
    public List<Connection> updateOpenshiftRoute(UUID environmentId) {
        this.systemRepository.getContext().setFullDbFetching(true);
        List<Connection> openShiftServerConnection = this.connectionRepository.getAll(environmentId, Constants.Environment.System.Connection.OPENSHIFT_SERVER, Constants.SystemCategories.OPENSHIFT_SERVER);
        return this.updateUrlRoutes(environmentId, Constants.Environment.System.Connection.OPENSHIFT_SYSTEM, openShiftServerConnection);
    }

    @Override
    public List<Connection> updateOpenshiftRoute(UUID systemId, UUID environmentId) {
        this.systemRepository.getContext().setFullDbFetching(true);
        List<Connection> openShiftServerConnection = this.connectionRepository.getAll(environmentId, Constants.Environment.System.Connection.OPENSHIFT_SERVER, Constants.SystemCategories.OPENSHIFT_SERVER, systemId);
        return this.updateUrlRoutes(environmentId, Constants.Environment.System.Connection.OPENSHIFT_SYSTEM, openShiftServerConnection);
    }

    @Override
    @Cacheable(value={"ATP_ENVIRONMENTS-SYSTEM_VERSION"}, key="#id", condition="#id!=null")
    public Object getCachedVersionById(UUID id) {
        this.systemRepository.getContext().setFullDbFetching(true);
        return this.updateVersionBySystemId(id, false);
    }

    @Override
    @Cacheable(value={"ATP_ENVIRONMENTS-SYSTEM_VERSION"}, key="#system.id", condition="#system!=null && #system.id!=null")
    public System getCachedVersionBySystem(System system) {
        this.systemRepository.getContext().setFullDbFetching(true);
        MDC.put((String)MdcField.SYSTEM_ID.toString(), (String)system.getId().toString());
        return this.updateVersionBySystem(system, false);
    }

    @Transactional
    public List<Connection> updateUrlRoutes(UUID environmentId, UUID openShiftSystemConnection, List<Connection> openShiftServerConnection) {
        this.systemRepository.getContext().setFullDbFetching(true);
        ArrayList<Connection> updatedConnections = new ArrayList<Connection>();
        List<Connection> connections = this.connectionRepository.getAll(environmentId, openShiftSystemConnection);
        for (Connection openShiftProject : openShiftServerConnection) {
            openShiftProject.setParameters(this.decryptorService.decryptParameters(openShiftProject.getParameters()));
            String etalonProject = (String)openShiftProject.getParameters().get((Object)"etalon_project");
            String project = (String)openShiftProject.getParameters().get((Object)"project");
            List projectIds = Stream.of(etalonProject, project).filter(str -> !Strings.isNullOrEmpty((String)str)).distinct().collect(Collectors.toList());
            OpenshiftClient osClient = (OpenshiftClient)ExternalCloudClient.createClient(openShiftProject.getParameters(), OpenshiftClient.class);
            for (String projectId : projectIds) {
                List<IRoute> routes;
                try {
                    routes = osClient.getRoutes(projectId);
                }
                catch (Exception e) {
                    log.error("Failed to fetch Openshift project: {}", (Object)projectId, (Object)e);
                    throw new EnvironmentOpenshiftProjectFetchException(projectId);
                }
                for (Connection connection : connections) {
                    if (!((String)connection.getParameters().get((Object)"root_synchronize_project")).equals(openShiftProject.getId().toString())) continue;
                    String routeNameParam = (String)connection.getParameters().get((Object)"route_name");
                    String routeUrl = osClient.getRouteUrl(routeNameParam, routes);
                    if (!routeUrl.isEmpty()) {
                        updatedConnections.add(connection);
                        connection.getParameters().put((Object)"url", (Object)routeUrl);
                        UUID systemId = this.connectionRepository.getSystemId(connection.getId());
                        this.connectionRepository.updateParameters(systemId, connection.getId(), connection.getParameters(), this.dateTimeUtil.timestampAsUtc(), ((UserInfo)this.userInfoProvider.get()).getId(), null);
                        continue;
                    }
                    log.info("route_name from Connection[ID:{}] not found", (Object)connection.getId());
                }
            }
        }
        return updatedConnections;
    }

    @Override
    @Transactional
    public System update(System system) {
        this.systemRepository.getContext().setFullDbFetching(true);
        return this.update(system.getId(), system.getName(), system.getDescription(), system.getSystemCategoryId(), system.getParametersGettingVersion(), system.getParentSystemId(), system.getServerItf(), system.getMergeByName(), system.getLinkToSystemId(), system.getExternalId(), system.getExternalName());
    }

    @Override
    @Transactional
    public System update(UUID id, String name, String description, UUID systemCategoryId, ParametersGettingVersion parametersGettingVersion, UUID parentSystemId, ServerItf serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, String externalName) {
        this.systemRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        System system = this.get(id);
        name = name.trim();
        if (!name.equals(system.getName())) {
            system.setName(name);
            system.getEnvironments().stream().map(Identified::getId).forEach(environmentId -> Preconditions.checkArgument((boolean)this.systemRepository.checkSystemNameIsUniqueUnderEnvironment((UUID)environmentId, system.getName()).isEmpty(), (String)"System with name \"%s\" already exists under environment \"%s\"", (Object)system.getName(), (Object)this.environmentRepository.getById((UUID)environmentId).getName()));
        }
        return this.systemRepository.update(id, name, description, this.dateTimeUtil.timestampAsUtc(), userId, systemCategoryId, Status.NOTHING, null, system.getVersion(), system.getDateOfCheckVersion(), parametersGettingVersion, parentSystemId, serverItf, mergeByName, linkToSystemId, externalId, externalName, true, true);
    }

    @Override
    @Transactional
    public System update(SystemDto system) {
        this.systemRepository.getContext().setFullDbFetching(true);
        List<UUID> environmentIdsToUnshare = null;
        List<UUID> environmentIdsToShare = null;
        ArrayList<UUID> environmentsToCheck = new ArrayList<UUID>();
        System existedSystem = this.get(system.getId());
        List<UUID> existedEnvironmentUuids = existedSystem.getEnvironmentIds().stream().map(Identified::getId).collect(Collectors.toList());
        if (system.getEnvironmentIds() != null) {
            List<UUID> newEnvironmentUuids = system.getEnvironmentIds();
            environmentIdsToUnshare = this.getDifference(existedEnvironmentUuids, newEnvironmentUuids);
            environmentIdsToShare = this.getDifference(newEnvironmentUuids, existedEnvironmentUuids);
        }
        if (this.isSystemNameChanged(system)) {
            environmentsToCheck.addAll(existedEnvironmentUuids);
        }
        if (environmentIdsToShare != null && !environmentIdsToShare.isEmpty()) {
            environmentsToCheck.addAll(environmentIdsToShare);
        }
        if (environmentIdsToUnshare != null && !environmentIdsToUnshare.isEmpty()) {
            environmentsToCheck.removeAll(environmentIdsToUnshare);
        }
        system.setName(system.getName().trim());
        for (UUID envId : environmentsToCheck) {
            Preconditions.checkArgument((boolean)this.systemRepository.checkSystemNameIsUniqueUnderEnvironment(envId, system.getName()).isEmpty(), (String)"System with name \"%s\" already exists under environment \"%s\"", (Object)system.getName(), (Object)Objects.requireNonNull(this.environmentRepository.getById(envId)).getName());
        }
        System result = this.update(system.getId(), system.getName(), system.getDescription(), system.getSystemCategoryId(), system.getParametersGettingVersion(), system.getParentSystemId(), system.getServerItf(), system.getMergeByName(), system.getLinkToSystemId(), system.getExternalId(), system.getExternalName());
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        if (system.getConnections() != null) {
            List connection = system.getConnections().stream().map(c -> {
                ConnectionParameters parameters = c.getParameters();
                if (parameters != null) {
                    parameters.replaceAll((k, v) -> v == null ? v : v.trim());
                }
                return new ConnectionDto(c.getId(), c.getName(), c.getSystemId(), parameters, c.getSourceTemplateId(), c.getConnectionType(), c.getCreated(), c.getModified(), c.getServices());
            }).map(conn -> this.connectionRepository.update(conn.getId(), conn.getSystemId(), conn.getName(), conn.getDescription(), conn.getParameters(), this.dateTimeUtil.timestampAsUtc(), userId, conn.getConnectionType(), conn.getSourceTemplateId(), conn.getServices())).collect(Collectors.toList());
            result.setConnections(connection);
        }
        if (system.getEnvironmentIds() != null) {
            List<Environment> environmentsToShare = this.environmentRepository.getByIds(environmentIdsToShare);
            if (!CollectionUtils.isEmpty(environmentsToShare)) {
                environmentsToShare.forEach(environment -> this.systemRepository.share(system.getId(), (Environment)environment, this.dateTimeUtil.timestampAsUtc(), userId));
            }
            environmentIdsToUnshare.forEach(id -> this.systemRepository.unShare(system.getId(), (UUID)id, this.dateTimeUtil.timestampAsUtc(), userId));
            List environmentIds = system.getEnvironmentIds().stream().map(this.environmentRepository::getById).collect(Collectors.toList());
            result.setEnvironmentIds(environmentIds);
        }
        return result;
    }

    public boolean isSystemNameChanged(SystemDto system) {
        return !system.getName().equals(this.systemRepository.getById(system.getId()).getName());
    }

    public List<UUID> getDifference(List<UUID> first, List<UUID> second) {
        List<UUID> result = new ArrayList<UUID>();
        if (first != null && second != null) {
            result = first.stream().filter(id -> !second.contains(id)).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    @Transactional
    public void delete(UUID id, UUID environmentId) {
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        this.systemRepository.delete(id, environmentId, this.dateTimeUtil.timestampAsUtc(), userId, true);
    }

    @Override
    @Transactional
    public void deleteLinkedServices(UUID parentSystemId, UUID environmentId) {
        List<System> services = this.getLinkedSystemByParentId(parentSystemId);
        List<UUID> serviceIds = services.stream().map(Identified::getId).collect(Collectors.toList());
        this.deleteSystemsByIds(serviceIds, environmentId);
    }

    @Override
    @Transactional
    public void deleteSystemsByIds(List<UUID> systemIds, UUID environmentId) {
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        systemIds.forEach(id -> this.systemRepository.delete((UUID)id, environmentId, this.dateTimeUtil.timestampAsUtc(), userId, false));
        this.kafkaService.sendEnvironmentKafkaNotification(environmentId, EventType.UPDATE, this.environmentRepository.getProjectId(environmentId));
    }

    @Override
    public List<Connection> getConnections(UUID systemId) {
        return this.connectionRepository.getAllByParentId(systemId);
    }

    @Override
    public Connection getConnectionBySystemIdAndConnectionType(UUID systemId, UUID connectionType) {
        List<Connection> connections = this.connectionRepository.getAllByParentIdAndConnectionType(systemId, connectionType);
        return !connections.isEmpty() ? connections.get(0) : null;
    }

    @Override
    public System saveStatusAndDateOfLastCheck(UUID id, Status status) {
        this.systemRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        System system = this.get(id);
        return this.saveStatusAndDateOfLastCheck(system, status, userId);
    }

    @Transactional
    public System saveStatusAndDateOfLastCheck(System system, Status status, UUID userId) {
        this.systemRepository.getContext().setFullDbFetching(true);
        MDC.put((String)MdcField.SYSTEM_ID.toString(), (String)system.getId().toString());
        return this.systemRepository.update(system.getId(), system.getName(), system.getDescription(), this.dateTimeUtil.timestampAsUtc(), userId, system.getSystemCategoryId(), status, this.dateTimeUtil.timestampAsUtc(), system.getVersion(), system.getDateOfCheckVersion(), system.getParametersGettingVersion(), system.getParentSystemId(), system.getServerItf(), system.getMergeByName(), system.getLinkToSystemId(), system.getExternalId(), system.getExternalName(), true, false);
    }

    @Override
    public List<System> saveStatusesAndDateOfLastCheck(List<StatusDto> statuses, UUID projectId) {
        try {
            this.systemRepository.getContext().setFullDbFetching(true);
            UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
            List<UUID> systemIds = statuses.stream().map(StatusDto::getSystemId).collect(Collectors.toList());
            List<System> systems = this.systemRepository.getSystemsByIdsAndProjectId(systemIds, projectId);
            ImmutableMap statusesMap = Maps.uniqueIndex(statuses, StatusDto::getSystemId);
            HashMap<System, Status> newStatusesMap = new HashMap<System, Status>();
            for (System system : systems) {
                newStatusesMap.put(system, Status.valueOf((String)((StatusDto)statusesMap.get(system.getId())).getStatus()));
            }
            return newStatusesMap.entrySet().stream().map(entry -> this.saveStatusAndDateOfLastCheck((System)entry.getKey(), (Status)entry.getValue(), userId)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Error occurred while statuses updating in project : {}", (Object)projectId, (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    @Transactional
    @CachePut(value={"ATP_ENVIRONMENTS-SYSTEM_VERSION"}, key="#system.id", condition="#system.id!=null")
    public System saveVersionAndDateOfLastCheck(System system, String version) {
        this.systemRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        return this.systemRepository.update(system.getId(), system.getName(), system.getDescription(), this.dateTimeUtil.timestampAsUtc(), userId, system.getSystemCategoryId(), system.getStatus(), system.getDateOfLastCheck(), version, this.dateTimeUtil.timestampAsUtc(), system.getParametersGettingVersion(), system.getParentSystemId(), system.getServerItf(), system.getMergeByName(), system.getLinkToSystemId(), system.getExternalId(), system.getExternalName(), false, false);
    }

    public String getSystemVersionByTypeCheck(System system) {
        this.systemRepository.getContext().setFullDbFetching(true);
        String version = null;
        Stopwatch timer = Stopwatch.createStarted();
        try {
            ParametersGettingVersion paramsGetVersion = system.getParametersGettingVersion();
            if (paramsGetVersion != null) {
                log.info("Start check version for system [ID:{}, Name:{}, Project ID:{}] by check version type: {}", new Object[]{system.getId(), system.getName(), ((Environment)system.getEnvironments().get(0)).getProjectId(), paramsGetVersion.getType()});
                VersionChecker versionChecker = this.versionCheckerFactory.createChecker(system);
                version = this.getPostProcessedVersion(paramsGetVersion, versionChecker.getVersion(), system);
                log.info("End of check version for system [ID:{}, Name:{}, Project ID:{}] by check version type: {}", new Object[]{system.getId(), system.getName(), ((Environment)system.getEnvironments().get(0)).getProjectId(), paramsGetVersion.getType()});
            }
        }
        catch (RuntimeException e) {
            try {
                log.error("Error occurred while check version for system [ID:{}, Name:{}, Project ID:{}]", new Object[]{system.getId(), system.getName(), ((Environment)system.getEnvironments().get(0)).getProjectId()});
                throw e;
            }
            catch (Throwable throwable) {
                String projectId = system == null || CollectionUtils.isEmpty((Collection)system.getEnvironments()) ? "unknown" : ((Environment)system.getEnvironments().get(0)).getProjectId().toString();
                this.metricService.checkVersionTimer("project", projectId).record(timer.stop().elapsed());
                throw throwable;
            }
        }
        String projectId = system == null || CollectionUtils.isEmpty((Collection)system.getEnvironments()) ? "unknown" : ((Environment)system.getEnvironments().get(0)).getProjectId().toString();
        this.metricService.checkVersionTimer("project", projectId).record(timer.stop().elapsed());
        return !StringUtils.isBlank(version) ? version : "Unknown";
    }

    private String getPostProcessedVersion(ParametersGettingVersion paramsGetVersion, String version, System system) {
        if (!StringUtils.isEmpty((CharSequence)paramsGetVersion.getParsingValue())) {
            switch (paramsGetVersion.getParsingType()) {
                case REGEXP: {
                    String threadName = Thread.currentThread().getName();
                    try {
                        this.changeRegexpThreadName(system, "regexpThread");
                        log.info("Start version processing by regexp. System ID:{}, Regexp Pattern:{} ", (Object)system.getId(), (Object)paramsGetVersion.getParsingValue());
                        String string = this.regexpHandler.getByRegExp(version, paramsGetVersion.getParsingValue(), this.regexpTimeout);
                        return string;
                    }
                    catch (RuntimeException e) {
                        log.error("Error while check version regexp processing, System ID:{}, Cause:{}", (Object)system.getId(), (Object)e.getMessage());
                        throw e;
                    }
                    finally {
                        Thread.currentThread().setName(threadName);
                    }
                }
                case JSONPATH: {
                    return this.jsonPathHandler.getByJsonpath(version, paramsGetVersion.getParsingValue());
                }
            }
        }
        return version;
    }

    private void changeRegexpThreadName(System system, String threadPrefix) {
        if (system != null) {
            Environment environment = null;
            if (!CollectionUtils.isEmpty((Collection)system.getEnvironments())) {
                environment = (Environment)system.getEnvironments().get(0);
            }
            String newThreadName = threadPrefix + UUID.randomUUID() + "-systemName:" + system.getName();
            if (environment != null) {
                newThreadName = newThreadName + "-environmentName:" + environment.getName() + "-projectId:" + environment.getProjectId();
            }
            Thread.currentThread().setName(newThreadName.replace(" ", "_"));
        }
    }

    @Override
    public System updateVersionBySystemId(UUID id, boolean updateCache) {
        this.systemRepository.getContext().setFullDbFetching(true);
        MDC.put((String)MdcField.SYSTEM_ID.toString(), (String)id.toString());
        System system = this.get(id);
        return this.updateVersionBySystem(system, updateCache);
    }

    public System updateVersionBySystem(System system, boolean updateCache) {
        this.systemRepository.getContext().setFullDbFetching(true);
        Preconditions.checkNotNull((Object)system, (Object)"System not found.");
        String version = this.getSystemVersionByTypeCheck(system);
        Preconditions.checkNotNull((Object)version, (Object)"Version not found.");
        if (updateCache) {
            return this.ref.saveVersionAndDateOfLastCheck(system, version);
        }
        return this.saveVersionAndDateOfLastCheck(system, version);
    }

    @Override
    public System transformSystemVersionToHtml(System system) {
        String version = system.getVersion();
        StringBuilder tableTagWithVersion = new StringBuilder("<table>");
        for (String versionString : version.split("\n")) {
            tableTagWithVersion.append("<tr><td>").append(versionString).append("</td></tr>");
        }
        tableTagWithVersion.append("</table>");
        system.setVersion(tableTagWithVersion.toString());
        return system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CacheEvict(value={"ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID"}, key="#id", condition="#id!=null")
    public List<System> updateVersionByEnvironmentId(UUID id) {
        this.systemRepository.getContext().setFullDbFetching(true);
        List listSystems = this.systemRepository.getAllByParentId(id).stream().filter(e -> e.getParametersGettingVersion() != null).collect(Collectors.toList());
        ArrayList<System> listSystemsWithUpdatedVersions = new ArrayList<System>();
        for (System system : listSystems) {
            MDC.put((String)MdcField.SYSTEM_ID.toString(), (String)system.getId().toString());
            String version = "";
            System updatedSystem = null;
            try {
                version = this.getSystemVersionByTypeCheck(system);
                if (version == null) {
                    throw new NullPointerException("Version is null");
                }
                updatedSystem = this.ref.saveVersionAndDateOfLastCheck(system, version);
                listSystemsWithUpdatedVersions.add(updatedSystem);
            }
            catch (Exception e2) {
                try {
                    log.error("An error occurred while getting version of system (systemName: {} , systemId: {} )", new Object[]{system.getName(), system.getId().toString(), e2});
                    updatedSystem = this.ref.saveVersionAndDateOfLastCheck(system, "Unknown");
                    updatedSystem.setCheckVersionError(e2.getMessage());
                    updatedSystem.setVersion("ERROR");
                    listSystemsWithUpdatedVersions.add(updatedSystem);
                }
                catch (Throwable throwable) {
                    listSystemsWithUpdatedVersions.add(updatedSystem);
                    throw throwable;
                }
            }
        }
        return listSystemsWithUpdatedVersions;
    }

    @Override
    public List<System> getByIds(List<UUID> systems) {
        return this.systemRepository.getByListIds(systems);
    }

    @Override
    public List<System> createListFromCloudServer(List<UUID> serviceIds, UUID cloudServerSystemId, UUID environmentId, Class<? extends ExternalCloudClient> clientClass) {
        this.systemRepository.getContext().setFullDbFetching(true);
        ExternalCloudClient cloudClient = this.getCloudClient(cloudServerSystemId, clientClass);
        ArrayList<System> createdSystems = new ArrayList<System>();
        List<CloudService> serviceList = cloudClient.getServicesByServiceId(serviceIds);
        Connection httpConnectionTemplate = this.connectionRepository.getById(Constants.Environment.System.Connection.HTTP);
        UUID serviceTemplateId = this.getConstantByClientClass(clientClass, true);
        serviceList.forEach(service -> {
            System newService = this.create(environmentId, service.getName(), null, serviceTemplateId, new ParametersGettingVersion(), null, null, false, cloudServerSystemId, service.getId(), service.getName());
            if (service.getHost() != null && service.getHost().length() > 0) {
                ConnectionParameters parameters = httpConnectionTemplate.getParameters();
                String url = serviceTemplateId.equals(Constants.SystemCategories.KUBERNETES_SERVICE) ? "https://" + service.getHost() : service.getHost();
                parameters.put((Object)"url", (Object)url);
                Connection httpConnection = this.connectionService.create(newService.getId(), httpConnectionTemplate.getName(), httpConnectionTemplate.getDescription(), parameters, httpConnectionTemplate.getConnectionType(), httpConnectionTemplate.getId(), this.systemRepository.getProjectId(newService.getId()), httpConnectionTemplate.getServices());
                newService.getConnections().add(httpConnection);
            }
            createdSystems.add(newService);
        });
        return createdSystems;
    }

    @Override
    public List<System> updateServicesFromCloudServer(UUID cloudServerSystemId, Class<? extends ExternalCloudClient> clientClass) {
        this.systemRepository.getContext().setFullDbFetching(true);
        List<System> existingServices = this.systemRepository.getByLinkToSystemId(cloudServerSystemId);
        ExternalCloudClient client = this.getCloudClient(cloudServerSystemId, clientClass);
        List<CloudService> cloudServices = client.getServicesByExistingServices(existingServices);
        ArrayList updatedConnections = new ArrayList();
        ArrayList<System> updatedSystems = new ArrayList<System>();
        existingServices.forEach(existingService -> {
            List foundServices = cloudServices.stream().filter(cloudService -> Objects.nonNull(existingService.getExternalId()) && existingService.getExternalId().equals(cloudService.getId())).collect(Collectors.toList());
            if (foundServices.isEmpty()) {
                foundServices = cloudServices.stream().filter(cloudService -> Objects.nonNull(existingService.getExternalName()) && existingService.getExternalName().equals(cloudService.getName())).collect(Collectors.toList());
            }
            if (!foundServices.isEmpty()) {
                String httpUrl;
                CloudService serviceFromCloudServer = (CloudService)foundServices.get(0);
                existingService.setName(serviceFromCloudServer.getName());
                existingService.setExternalName(serviceFromCloudServer.getName());
                existingService.setExternalId(serviceFromCloudServer.getId());
                String string = httpUrl = existingService.getSystemCategory().getId().equals(Constants.SystemCategories.KUBERNETES_SERVICE) ? "https://" + serviceFromCloudServer.getHost() : serviceFromCloudServer.getHost();
                if (httpUrl != null && httpUrl.length() > 0) {
                    ArrayList httpConnections = new ArrayList();
                    existingService.getConnections().forEach(connection -> {
                        if (connection.getSourceTemplateId().equals(Constants.Environment.System.Connection.HTTP)) {
                            httpConnections.add(connection);
                        }
                    });
                    if (httpConnections.size() == 0) {
                        Connection httpConnectionTemplate = this.connectionRepository.getById(Constants.Environment.System.Connection.HTTP);
                        ConnectionParameters parameters = httpConnectionTemplate.getParameters();
                        parameters.put((Object)"url", (Object)httpUrl);
                        updatedConnections.add(this.connectionService.create(existingService.getId(), httpConnectionTemplate.getName(), httpConnectionTemplate.getDescription(), parameters, httpConnectionTemplate.getConnectionType(), httpConnectionTemplate.getId(), this.systemRepository.getProjectId(existingService.getId()), httpConnectionTemplate.getServices()));
                    } else {
                        ((Connection)httpConnections.get(0)).getParameters().put((Object)"url", (Object)httpUrl);
                        updatedConnections.add(this.connectionService.update((Connection)httpConnections.get(0)));
                    }
                }
                existingService.setConnections(updatedConnections);
                this.update((System)existingService);
                updatedSystems.add((System)existingService);
            }
        });
        return updatedSystems;
    }

    @Override
    public List<ShortExternalService> getShortExternalServices(UUID kubernetesServerSystemId, Class<? extends ExternalCloudClient> clientClass) {
        return this.getCloudClient(kubernetesServerSystemId, clientClass).getShortServices();
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private ExternalCloudClient getCloudClient(UUID kubernetesServerSystemId, Class<? extends ExternalCloudClient> clientClass) {
        ExternalCloudClient client;
        this.systemRepository.getContext().setFullDbFetching(true);
        try {
            System cloudServerSystem = this.systemRepository.getById(kubernetesServerSystemId);
            Preconditions.checkNotNull((Object)cloudServerSystem, (String)"Server for {} not found.", clientClass);
            Connection cloudConnection = this.getConnectionBySystemIdAndConnectionType(cloudServerSystem.getId(), this.getConstantByClientClass(clientClass, false));
            Connection decryptedCloudConnection = this.decryptorService.decryptConnection(cloudConnection);
            Preconditions.checkNotNull((Object)decryptedCloudConnection, (String)"Project for {} not found.", clientClass);
            client = ExternalCloudClient.createClient(decryptedCloudConnection.getParameters(), clientClass);
        }
        catch (Exception e) {
            String clientClassName = clientClass.getName();
            log.error("Failed to create cloud client for class: {}", (Object)clientClassName);
            throw new EnvironmentCloudClientCreationException(clientClassName);
        }
        return client;
    }

    private UUID getConstantByClientClass(Class<? extends ExternalCloudClient> clientClass, boolean isSystemCategory) {
        if (clientClass.equals(OpenshiftClient.class)) {
            if (isSystemCategory) {
                return Constants.SystemCategories.OPENSHIFT_SERVICE;
            }
            return Constants.Environment.System.Connection.OPENSHIFT_SERVER;
        }
        if (clientClass.equals(KubeClient.class)) {
            if (isSystemCategory) {
                return Constants.SystemCategories.KUBERNETES_SERVICE;
            }
            return Constants.Environment.System.Connection.KUBERNETES_PROJECT;
        }
        String className = clientClass.getName();
        log.error("Failed to find cloud connection template by specified class: {}", (Object)className);
        throw new EnvironmentIllegalCloudConnectionTemplateClassException(className);
    }

    @Override
    @Transactional
    public System updateParametersGettingVersion(UUID id, ParametersGettingVersion parametersGettingVersion) {
        this.systemRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        System system = this.systemRepository.getById(id);
        return this.systemRepository.update(id, system.getName(), system.getDescription(), this.dateTimeUtil.timestampAsUtc(), userId, system.getSystemCategoryId(), system.getStatus(), system.getDateOfLastCheck(), system.getVersion(), system.getDateOfCheckVersion(), parametersGettingVersion, system.getParentSystemId(), system.getServerItf(), system.getMergeByName(), system.getLinkToSystemId(), system.getExternalId(), system.getExternalName(), true, true);
    }

    @Override
    public List<System> getLinkedSystemByParentId(UUID systemId) {
        return this.systemRepository.getByLinkToSystemId(systemId);
    }

    @Override
    public System getBySourceId(UUID sourceId) {
        return this.systemRepository.getBySourceId(sourceId);
    }

    @Override
    public List<System> getSystemsByProjectId(UUID projectId) {
        return this.systemRepository.getSystemsByProjectId(projectId);
    }

    @Override
    public List<System> getSystemsByProjectIdAndCategoryName(UUID projectId, String categoryName) {
        UUID categoryId = this.systemCategoriesService.getByName(categoryName).getId();
        List<System> systemList = this.getSystemsByProjectId(projectId);
        return systemList.stream().filter(system -> categoryId.equals(system.getSystemCategoryId())).collect(Collectors.toList());
    }

    @Override
    public System getShortSystem(UUID id) {
        return this.systemRepository.getShortById(id);
    }

    @Override
    @Nullable
    public System getSystemByNameAndEnvironmentId(String name, UUID environmentId) {
        return this.systemRepository.getSystemByNameAndEnvironmentId(name, environmentId);
    }
}

