/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.UpdateEvent;
import org.qubership.atp.environments.repo.impl.UpdateEventRepositoryImpl;
import org.qubership.atp.environments.service.direct.UpdateEventService;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="updateEventService")
public class UpdateEventServiceImpl
implements UpdateEventService {
    private final UpdateEventRepositoryImpl updateEventRepository;
    private final DateTimeUtil dateTimeUtil;

    @Autowired
    public UpdateEventServiceImpl(UpdateEventRepositoryImpl updateEventRepository, DateTimeUtil dateTimeUtil) {
        this.updateEventRepository = updateEventRepository;
        this.dateTimeUtil = dateTimeUtil;
    }

    @Override
    @Nullable
    public UpdateEvent get(@Nonnull UUID subscriptionId, @Nonnull UUID entityId) {
        return this.updateEventRepository.getById(subscriptionId, entityId);
    }

    @Override
    @Nullable
    public UpdateEvent getSubscriptionUpdateEvents(@Nonnull UUID subscriptionId) {
        return this.updateEventRepository.getBySubscriptionId(subscriptionId);
    }

    @Override
    @Nullable
    public UpdateEvent getEntityUpdateEvents(@Nonnull UUID entityId) {
        return this.updateEventRepository.getByEntityId(entityId);
    }

    @Override
    @Nonnull
    public List<UpdateEvent> getAll() {
        return this.updateEventRepository.getAll();
    }

    @Override
    @Nonnull
    public UpdateEvent create(@Nonnull UUID subscriptionId, UUID entityId, String tagList, Integer status, String entityType) {
        return this.updateEventRepository.create(subscriptionId, entityId, tagList, status, this.dateTimeUtil.timestampAsUtc(), entityType);
    }

    @Override
    public void update(UUID subscriptionId, UUID entityId, String tagList, Integer status, String entityType) {
        this.updateEventRepository.update(subscriptionId, entityId, tagList, status, this.dateTimeUtil.timestampAsUtc(), entityType);
    }

    @Override
    public void delete(UUID subscriptionId, UUID entityId) {
        this.updateEventRepository.delete(subscriptionId, entityId);
    }
}

