/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.notification;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.UUID;
import org.qubership.atp.environments.service.notification.EventNotificationService;
import org.qubership.atp.environments.service.rest.server.dto.ProducerNotificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaEventNotificationService
implements EventNotificationService {
    private static final Logger log = LoggerFactory.getLogger(KafkaEventNotificationService.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String topicName;
    private final KafkaTemplate<UUID, String> kafkaTemplate;

    public KafkaEventNotificationService(KafkaTemplate<UUID, String> kafkaTemplate, String topicName) {
        this.kafkaTemplate = kafkaTemplate;
        this.topicName = topicName;
    }

    @Override
    public void notify(ProducerNotificationEvent event) {
        try {
            this.kafkaTemplate.send(this.topicName, (Object)event.getId(), (Object)this.objectMapper.writeValueAsString((Object)event));
        }
        catch (Exception e) {
            log.error("NotificationService can't write to kafka", (Throwable)e);
        }
    }
}

