/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.notification;

import com.google.gson.Gson;
import org.qubership.atp.environments.errorhandling.internal.EnvironmentJsonParseException;
import org.qubership.atp.environments.errorhandling.project.EnvironmentIllegalProjectEventTypeException;
import org.qubership.atp.environments.model.Project;
import org.qubership.atp.environments.model.impl.ProjectImpl;
import org.qubership.atp.environments.service.direct.ProjectService;
import org.qubership.atp.environments.service.notification.ProjectEventListener;
import org.qubership.atp.environments.service.rest.server.dto.EventType;
import org.qubership.atp.environments.service.rest.server.dto.ProjectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;

public class ProjectEventKafkaListener
implements ProjectEventListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectEventKafkaListener.class);
    private final ProjectService projectService;

    public ProjectEventKafkaListener(ProjectService projectService) {
        this.projectService = projectService;
    }

    @Override
    @KafkaListener(topics={"${kafka.catalogue.topic:catalog_notification_topic}"})
    public void listen(String event) {
        ProjectEvent projectEvent;
        try {
            projectEvent = (ProjectEvent)new Gson().fromJson(event, ProjectEvent.class);
        }
        catch (Exception e) {
            log.error("Failed to parse json and get project event entity", (Throwable)e);
            throw new EnvironmentJsonParseException("Failed to parse JSON and get project event entity");
        }
        EventType projectEventType = projectEvent.getType();
        switch (projectEventType) {
            case CREATE: {
                ProjectImpl project = new ProjectImpl();
                project.setId(projectEvent.getProjectId());
                project.setShortName(projectEvent.getProjectName());
                project.setName(projectEvent.getProjectName());
                this.projectService.createAsIs((Project)project);
                break;
            }
            case UPDATE: {
                ProjectImpl project = new ProjectImpl();
                project.setId(projectEvent.getProjectId());
                project.setShortName(projectEvent.getProjectName());
                project.setName(projectEvent.getProjectName());
                this.projectService.update(projectEvent.getProjectId(), projectEvent.getProjectName(), projectEvent.getProjectName());
                break;
            }
            case DELETE: {
                this.projectService.delete(projectEvent.getProjectId());
                break;
            }
            default: {
                log.error("Failed to find project event by specified type: {}", (Object)projectEventType);
                throw new EnvironmentIllegalProjectEventTypeException(projectEventType.name());
            }
        }
    }
}

