/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.model.Alert;
import org.qubership.atp.environments.model.impl.AlertImpl;
import org.qubership.atp.environments.service.direct.AlertService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/alerts"})
@RestController
public class AlertController {
    private final AlertService alertService;

    @Autowired
    public AlertController(AlertService service) {
        this.alertService = service;
    }

    @GetMapping(value={"/{alertId}"})
    @AuditAction(auditAction="Get alert by {{#uuid}}")
    public Alert getAlert(@PathVariable(value="alertId") UUID uuid) {
        return (Alert)this.alertService.get(uuid);
    }

    @GetMapping
    @AuditAction(auditAction="Get all alerts.")
    public List<Alert> getAll() {
        return this.alertService.getAll();
    }

    @PostMapping(value={"/create"})
    @AuditAction(auditAction="Create new alert {{#alert.shortDescription}}")
    public Alert create(@RequestBody AlertImpl alert) {
        return this.alertService.create(alert.getName(), alert.getShortDescription(), alert.getTagList(), alert.getParameters(), alert.getSubscriberId(), alert.getStatus());
    }

    @PutMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Update alert {{#alert.shortDescription}}")
    public void update(@RequestBody AlertImpl alert) {
        Preconditions.checkNotNull((Object)alert.getId(), (Object)"Alert id can't be empty");
        Preconditions.checkNotNull((Object)alert.getSubscriberId(), (Object)"Subscriber id can't be empty");
        this.alertService.update((Alert)alert);
    }

    @DeleteMapping(value={"/{alertId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete alert {{#alert.shortDescription}}")
    public void delete(@PathVariable(value="alertId") UUID alertId) {
        this.alertService.delete(alertId);
    }
}

