/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.model.AlertEvent;
import org.qubership.atp.environments.model.impl.AlertEventImpl;
import org.qubership.atp.environments.service.direct.AlertEventService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/alertEvents"})
@RestController
public class AlertEventController {
    private final AlertEventService alertEventService;

    @Autowired
    public AlertEventController(AlertEventService service) {
        this.alertEventService = service;
    }

    @GetMapping(value={"/alert/{alertId}/entity/{entityId}"})
    @AuditAction(auditAction="Get alert event {{#alertId.toString()}} entityId {{#entityId.toString()}}")
    public AlertEvent getAlertEvent(@PathVariable(value="alertId") UUID alertId, @PathVariable(value="entityId") UUID entityId) {
        return this.alertEventService.get(alertId, entityId);
    }

    @GetMapping
    @AuditAction(auditAction="Get all alert events")
    public List<AlertEvent> getAll() {
        return this.alertEventService.getAll();
    }

    @PostMapping
    @AuditAction(auditAction="Create alert event {{#alertEvent.alertId}}")
    public AlertEvent create(@RequestBody AlertEventImpl alertEvent) {
        return this.alertEventService.create(alertEvent.getAlertId(), alertEvent.getEntityId(), alertEvent.getTagList(), alertEvent.getStatus());
    }

    @PutMapping(value={"/alert/{alertId}/entity/{entityId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Update alert event {{#alert.alertId.toString()}}")
    public void update(@RequestBody AlertEventImpl alertEvent) {
        Preconditions.checkNotNull((Object)alertEvent.getEntityId(), (Object)"Entity id can't be empty");
        Preconditions.checkNotNull((Object)alertEvent.getAlertId(), (Object)"Alert id can't be empty");
        this.alertEventService.update(alertEvent.getAlertId(), alertEvent.getEntityId(), alertEvent.getTagList(), alertEvent.getStatus());
    }

    @DeleteMapping(value={"/alert/{alertId}/entity/{entityId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete alert event {{#alertId.toString()}}")
    public void delete(@PathVariable(value="alertId") UUID alertId, @PathVariable(value="entityId") UUID entityId) {
        this.alertEventService.delete(alertId, entityId);
    }
}

