/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.model.EnvironmentCategory;
import org.qubership.atp.environments.model.impl.EnvironmentCategoryImpl;
import org.qubership.atp.environments.service.direct.EnvironmentCategoryService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/environment-categories"})
@RestController
public class EnvironmentCategoryController {
    private final EnvironmentCategoryService environmentCategoryService;

    @Autowired
    public EnvironmentCategoryController(EnvironmentCategoryService environmentCategoryService) {
        this.environmentCategoryService = environmentCategoryService;
    }

    @GetMapping
    @AuditAction(auditAction="Get list of environment categories.")
    public List<EnvironmentCategory> getAll() {
        return this.environmentCategoryService.getAll();
    }

    @GetMapping(value={"/{environmentCategoryId}"})
    @AuditAction(auditAction="Get environment category by id: {{#id.toString()}}")
    public EnvironmentCategory get(@PathVariable(value="environmentCategoryId") UUID id) {
        return (EnvironmentCategory)this.environmentCategoryService.get(id);
    }

    @PostMapping
    @AuditAction(auditAction="Create environment category with name {{#environmentCategory.name}}")
    public EnvironmentCategory create(@RequestBody EnvironmentCategoryImpl environmentCategory) {
        Preconditions.checkNotNull((Object)environmentCategory.getName(), (Object)"Environment category name can't be empty");
        return this.environmentCategoryService.create(environmentCategory.getName(), environmentCategory.getDescription(), environmentCategory.getTagList());
    }

    @PutMapping
    @AuditAction(auditAction="Update environment category with id {{#environmentCategory.id.toString()}}")
    public EnvironmentCategory update(@RequestBody EnvironmentCategoryImpl environmentCategory) {
        Preconditions.checkNotNull((Object)environmentCategory.getId(), (Object)"Environment category id can't be empty");
        Preconditions.checkNotNull((Object)environmentCategory.getName(), (Object)"Environment category name  can't be empty");
        return this.environmentCategoryService.update(environmentCategory.getId(), environmentCategory.getName(), environmentCategory.getDescription(), environmentCategory.getTagList());
    }

    @DeleteMapping(value={"/{environmentCategoryId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete environment category {{#id.toString()}}")
    public void delete(@PathVariable(value="environmentCategoryId") UUID id) {
        this.environmentCategoryService.delete(id);
    }
}

