/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.environments.enums.MdcField;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.model.utils.View;
import org.qubership.atp.environments.repo.impl.ContextRepository;
import org.qubership.atp.environments.service.direct.ConcurrentModificationService;
import org.qubership.atp.environments.service.direct.EnvironmentService;
import org.qubership.atp.environments.service.direct.SystemService;
import org.qubership.atp.environments.service.rest.server.dto.BaseSearchRequestDto;
import org.qubership.atp.environments.service.rest.server.dto.CreateSystemDto;
import org.qubership.atp.environments.service.rest.server.dto.EnvironmentDto;
import org.qubership.atp.environments.service.rest.server.dto.SystemTemporaryDto;
import org.qubership.atp.environments.service.rest.server.request.EnvironmentsWithFilterRequest;
import org.qubership.atp.environments.service.rest.server.response.SystemVersionResponse;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api"})
@RestController
public class EnvironmentController {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentController.class);
    private final EnvironmentService environmentService;
    private final SystemService systemService;
    private final ConcurrentModificationService concurrentModificationService;
    private final ContextRepository contextRepository;
    private final UUID categoryId = Constants.Environment.Category.ENVIRONMENT;

    @Autowired
    public EnvironmentController(EnvironmentService service, SystemService systemService, ConcurrentModificationService concurrentModificationService, ContextRepository contextRepository) {
        this.environmentService = service;
        this.systemService = systemService;
        this.concurrentModificationService = concurrentModificationService;
        this.contextRepository = contextRepository;
    }

    @GetMapping(value={"/environments"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get all environment")
    public List<Environment> getAll() {
        return this.environmentService.getAll(this.categoryId);
    }

    @PostMapping(value={"/environments/search"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get environments by search request projectId in search request: {{#searchRequest.projectId.toString()}} ")
    public List<Environment> findBySearchRequest(@RequestBody BaseSearchRequestDto searchRequest) throws Exception {
        return this.environmentService.findBySearchRequest(searchRequest);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).ENVIRONMENT.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'READ')")
    @GetMapping(value={"/environments/{environmentId}"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get environment by uuid {{#environmentId.toString()}} ")
    public Environment getEnvironment(@PathVariable(value="environmentId") UUID environmentId) {
        return (Environment)this.environmentService.get(environmentId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).ENVIRONMENT.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'READ')")
    @GetMapping(value={"/environments/{environmentId}/name"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get environment name by uuid {{#environmentId.toString()}} ")
    public ResponseEntity<String> getEnvironmentNameById(@PathVariable(value="environmentId") UUID environmentId) {
        return Optional.ofNullable(this.environmentService.getEnvironmentNameById(environmentId)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).ENVIRONMENT.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'UPDATE')")
    @GetMapping(value={"/environments/{environmentId}/systems/update-versions"})
    @JsonView(value={View.FullVer1.class})
    @Operation(description="Returns all systems with updated versions under environment {{#environmentId.toString()}}")
    @AuditAction(auditAction="Get environment tsg by uuid {{#environmentId.toString()}} ")
    public Environment getEnvironmentTsg3(@Parameter(description="Id of the environment. Cannot be empty.") @PathVariable(value="environmentId") UUID environmentId) {
        this.systemService.updateVersionByEnvironmentId(environmentId);
        return (Environment)this.environmentService.get(environmentId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).ENVIRONMENT.getName(),#request.getProjectId(),'READ')")
    @PostMapping(value={"/environments/filter"})
    @JsonView(value={View.FullVer1.class})
    @Operation(description="Returns all environments with setted specified fields by specified filter")
    public ResponseEntity<List<Environment>> getEnvironmentsByRequest(@RequestBody EnvironmentsWithFilterRequest request, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="size", required=false) Integer size) {
        return ResponseEntity.ok(this.environmentService.getEnvironmentsByFilterRequest(request, page, size));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'READ')")
    @GetMapping(value={"/environments/{environmentId}/systems"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get environment systems by environment uuid {{#environmentId.toString()}} and system type {{#systemType}}")
    public List<System> getEnvironmentSystems(@PathVariable(value="environmentId") UUID environmentId, @RequestParam(value="system_type", required=false) String systemType) {
        if (systemType != null) {
            return this.environmentService.getSystems(environmentId, systemType);
        }
        return this.environmentService.getSystems(environmentId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).CONNECTION.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'READ')")
    @GetMapping(value={"/environments/{environmentId}/connections"})
    @JsonView(value={View.FullVer1.class})
    public ResponseEntity<List<Connection>> getEnvironmentConnections(@PathVariable(value="environmentId") UUID environmentId) {
        return Optional.ofNullable(this.environmentService.getConnections(environmentId)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @RequestMapping(value={"/public/v1/environments/{environmentIds}/systems/htmlVersions"}, method={RequestMethod.GET}, produces={"text/plain"})
    @AuditAction(auditAction="Get html of system versions by environment list")
    public ResponseEntity<String> getPublicHtmlVersion(@PathVariable(value="environmentIds") List<UUID> environmentIds) {
        String htmlResponse = this.environmentService.getHtmlVersionByEnvironments(environmentIds);
        return StringUtils.isEmpty((Object)htmlResponse) ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)htmlResponse);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'READ')")
    @JsonView(value={View.Name.class})
    @GetMapping(value={"/environments/{environmentId}/systems/short"})
    @AuditAction(auditAction="Get short systems by environment uuid {{#environmentId.toString()}}")
    public List<System> getSystemsShort(@PathVariable(value="environmentId") UUID environmentId) {
        return this.environmentService.getShortSystems(environmentId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'READ')")
    @JsonView(value={View.FullVer2.class})
    @GetMapping(value={"/v2/environments/{environmentId}/systems"})
    @AuditAction(auditAction="Get system version2 by environment uuid {{#environmentId.toString()}} and system type {{#systemType}}")
    public Collection<System> getSystemV2(@PathVariable(value="environmentId") UUID environmentId, @RequestParam(value="system_type", required=false) String systemType) {
        log.info("Request to get systems for environment with id '{}' and type '{}'", (Object)environmentId, (Object)systemType);
        this.contextRepository.getContext().setFieldsToUnfold(new String[]{"environments", "connections", "systemCategory"});
        if (systemType != null) {
            return this.environmentService.getSystemsV2(environmentId, systemType);
        }
        return this.environmentService.getSystemsV2(environmentId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).ENVIRONMENT.getName(),#environmentDto.getProjectId(),'CREATE')")
    @PostMapping(value={"/environments"})
    @AuditAction(auditAction="Create environment with name: {{#environmentDto.name}}")
    public Environment createEnvironment(@RequestBody EnvironmentDto environmentDto) {
        return this.environmentService.create(environmentDto.getProjectId(), environmentDto.getName(), environmentDto.getGraylogName(), environmentDto.getDescription(), environmentDto.getSsmSolutionAlias(), environmentDto.getSsmInstanceAlias(), environmentDto.getConsulEgressConfigPath(), this.categoryId, environmentDto.getTags());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId), 'CREATE')")
    @PostMapping(value={"/environments/{environmentId}"})
    @AuditAction(auditAction="Create system with name {{#createSystemDto.name}} in environment uuid  {{#environmentId.toString()}}")
    public System createSystem(@PathVariable(value="environmentId") UUID environmentId, @RequestBody CreateSystemDto createSystemDto) {
        return this.environmentService.create(environmentId, createSystemDto);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).ENVIRONMENT.getName(),#environmentDto.getProjectId(),'CREATE')")
    @PostMapping(value={"/environments/{environmentId}/copy"})
    @AuditAction(auditAction="Copy environment with environment uuid {{#environmentId.toString()}}")
    public Environment copy(@PathVariable(value="environmentId") UUID environmentId, @RequestBody EnvironmentDto environmentDto) {
        return this.environmentService.copy(environmentId, environmentDto.getProjectId(), environmentDto.getName(), environmentDto.getGraylogName(), environmentDto.getDescription(), environmentDto.getSsmSolutionAlias(), environmentDto.getSsmInstanceAlias(), environmentDto.getConsulEgressConfigPath(), this.categoryId, environmentDto.getTags());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).ENVIRONMENT.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'CREATE')")
    @JsonView(value={View.FullVer1.class})
    @PostMapping(value={"/environments/{environmentId}/temporary"})
    @AuditAction(auditAction="Get temporary environment by uuid  {{#environmentId.toString()}}")
    public Environment temporary(@PathVariable(value="environmentId") UUID environmentId, @RequestBody List<SystemTemporaryDto> systemUpdateList) {
        this.contextRepository.getContext().setFieldsToUnfold(new String[]{"systems", "connections"});
        return this.environmentService.temporary(environmentId, systemUpdateList);
    }

    @JsonView(value={View.FullVer1.class})
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'UPDATE')")
    @GetMapping(value={"/environments/{environmentId}/version"})
    @AuditAction(auditAction="Update system versions in environment by environment uuid  {{#environmentId.toString()}}")
    public ResponseEntity<List<System>> updateVersion(@PathVariable(value="environmentId") UUID environmentId) {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(this.systemService.updateVersionByEnvironmentId(environmentId));
    }

    @JsonView(value={View.FullVer1.class})
    @PreAuthorize(value="@entityAccess.checkAccess(@environmentService.getProjectIdByEnvironmentId(#environmentId).toString(),'UPDATE')")
    @GetMapping(value={"/v2/environments/{environmentId}/version"})
    @AuditAction(auditAction="Detailed update all system version in environment by environment uuid  {{#environmentId.toString()}}")
    public ResponseEntity<List<SystemVersionResponse>> detailedUpdateVersion(@PathVariable(value="environmentId") UUID environmentId) {
        log.info("Start updating environment version");
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(this.systemService.updateVersionByEnvironmentId(environmentId).stream().map(system -> new SystemVersionResponse((System)system, system.getCheckVersionError())).collect(Collectors.toList()));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).ENVIRONMENT.getName(),#environmentDto.getProjectId(),'UPDATE')")
    @PutMapping(value={"/environments"})
    @AuditAction(auditAction="Update environment with id {{#environmentDto.id.toString()}}")
    public ResponseEntity updateEnvironment(@RequestBody EnvironmentDto environmentDto) {
        Preconditions.checkNotNull((Object)environmentDto.getId(), (Object)"Environment id can't be empty");
        Preconditions.checkNotNull((Object)environmentDto.getName(), (Object)"Environment name can't be empty");
        MdcUtils.put((String)MdcField.ENVIRONMENT_ID.toString(), (UUID)environmentDto.getId());
        HttpStatus status = this.concurrentModificationService.getConcurrentModificationHttpStatus(environmentDto.getId(), environmentDto.getModified(), this.environmentService);
        this.environmentService.update(environmentDto.getId(), environmentDto.getName(), environmentDto.getGraylogName(), environmentDto.getDescription(), environmentDto.getSsmSolutionAlias(), environmentDto.getSsmInstanceAlias(), environmentDto.getConsulEgressConfigPath(), environmentDto.getProjectId(), this.categoryId, environmentDto.getTags());
        return ResponseEntity.status((HttpStatus)status).body((Object)"");
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).ENVIRONMENT.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'DELETE')")
    @DeleteMapping(value={"/environments/{environmentId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete environment {{#environmentId.toString()}}")
    public void deleteEnvironment(@PathVariable(value="environmentId") UUID environmentId) {
        this.environmentService.delete(environmentId);
    }
}

