/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.errorhandling.history.EnvironmentIllegalHistoryEntityTypeArgumentException;
import org.qubership.atp.environments.service.rest.server.dto.generated.CompareEntityResponseDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.HistoryItemResponseDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.HistoryItemTypeDtoGenerated;
import org.qubership.atp.environments.service.rest.server.generated.HistoryControllerApi;
import org.qubership.atp.environments.versioning.model.entities.AbstractJaversEntity;
import org.qubership.atp.environments.versioning.model.entities.EnvironmentJ;
import org.qubership.atp.environments.versioning.model.entities.SystemJ;
import org.qubership.atp.environments.versioning.service.HistoryServiceFactory;
import org.qubership.atp.environments.versioning.service.JaversHistoryService;
import org.qubership.atp.environments.versioning.service.JaversRestoreServiceFactory;
import org.qubership.atp.environments.versioning.service.VersionHistoryService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HistoryController
implements HistoryControllerApi {
    private static final Logger log = LoggerFactory.getLogger(HistoryController.class);
    private final JaversHistoryService javersHistoryService;
    private final JaversRestoreServiceFactory javersRestoreServiceFactory;
    private HistoryServiceFactory historyServiceFactory;
    private final Map<String, Class<? extends AbstractJaversEntity>> javersClasses = ImmutableMap.of((Object)HistoryItemTypeDtoGenerated.ENVIRONMENT.toString(), EnvironmentJ.class, (Object)HistoryItemTypeDtoGenerated.TATOOL.toString(), EnvironmentJ.class, (Object)HistoryItemTypeDtoGenerated.SYSTEM.toString(), SystemJ.class);

    @Autowired
    public HistoryController(JaversHistoryService javersHistoryService, JaversRestoreServiceFactory javersRestoreServiceFactory, HistoryServiceFactory historyServiceFactory) {
        this.javersHistoryService = javersHistoryService;
        this.javersRestoreServiceFactory = javersRestoreServiceFactory;
        this.historyServiceFactory = historyServiceFactory;
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'READ')")
    @AuditAction(auditAction="Get all history with item type: {{#itemType}}")
    public ResponseEntity<HistoryItemResponseDtoGenerated> getAllHistory(@PathVariable(value="projectId") UUID projectId, @PathVariable(value="itemType") String itemType, @PathVariable(value="id") UUID entityId, @Valid @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @Valid @RequestParam(value="limit", required=false, defaultValue="10") Integer limit) {
        Class<? extends AbstractJaversEntity> javersClass = this.javersClasses.get(itemType);
        if (javersClass != null) {
            HistoryItemResponseDtoGenerated response = this.javersHistoryService.getAllHistory(entityId, javersClass, offset, limit);
            response.getHistoryItems().forEach(item -> item.setType(HistoryItemTypeDtoGenerated.fromValue(itemType)));
            return ResponseEntity.ok((Object)response);
        }
        log.error("History for Entity type '{}' is not supported", (Object)itemType);
        throw new EnvironmentIllegalHistoryEntityTypeArgumentException(itemType);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'READ')")
    @AuditAction(auditAction="Get entities by version projectId: {{#projectId.toString()}} item type: {{#itemType}}")
    public ResponseEntity<List<CompareEntityResponseDtoGenerated>> getEntitiesByVersion(@PathVariable(value="projectId") UUID projectId, @PathVariable(value="itemType") String itemType, @PathVariable(value="id") UUID entityId, @PathVariable(value="revisionIds") List<String> revisionIds) {
        Optional<VersionHistoryService> historyServiceOptional = this.historyServiceFactory.getHistoryService(itemType);
        if (historyServiceOptional.isPresent()) {
            VersionHistoryService versionHistoryService = historyServiceOptional.get();
            List<CompareEntityResponseDtoGenerated> response = versionHistoryService.getEntitiesByVersion(entityId, revisionIds);
            return ResponseEntity.ok(response);
        }
        log.error("History for Entity type '{}' is not supported", (Object)itemType);
        throw new EnvironmentIllegalHistoryEntityTypeArgumentException(itemType);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'UPDATE')")
    @AuditAction(auditAction="Restore to revision projectId: {{#projectId.toString()}} item type: {{#itemType}}")
    public ResponseEntity<Void> restoreToRevision(@PathVariable(value="projectId") UUID projectId, @PathVariable(value="itemType") String itemType, @PathVariable(value="id") UUID entityId, @PathVariable(value="revisionId") Integer revisionId) {
        Class<? extends AbstractJaversEntity> javersClass = this.javersClasses.get(itemType);
        if (javersClass != null) {
            this.javersRestoreServiceFactory.getRestoreService(javersClass).restore(javersClass, entityId, revisionId);
            return ResponseEntity.ok().build();
        }
        log.error("History for Entity type '{}' is not supported", (Object)itemType);
        throw new EnvironmentIllegalHistoryEntityTypeArgumentException(itemType);
    }
}

