/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.model.SystemCategory;
import org.qubership.atp.environments.model.impl.SystemCategoryImpl;
import org.qubership.atp.environments.model.utils.View;
import org.qubership.atp.environments.service.direct.SystemCategoriesService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/system-categories"})
@RestController
public class SystemCategoryController {
    private final SystemCategoriesService systemCategoriesService;

    @Autowired
    public SystemCategoryController(SystemCategoriesService systemCategoriesService) {
        this.systemCategoriesService = systemCategoriesService;
    }

    @GetMapping
    @AuditAction(auditAction="Get all system categories")
    public List<SystemCategory> getAllSystemCategories() {
        return this.systemCategoriesService.getAll();
    }

    @Operation(description="Getting system categories in abbreviated form :{id:\"\",name:\"\"}")
    @GetMapping(value={"/short"})
    @JsonView(value={View.Name.class})
    @AuditAction(auditAction="Get all short system categories")
    public List<SystemCategory> getShortAll() {
        return this.systemCategoriesService.getAll();
    }

    @GetMapping(value={"/{systemCategoryId}"})
    @AuditAction(auditAction="Get system category by id {{#id.toString()}}")
    public SystemCategory getSystemCategory(@PathVariable(value="systemCategoryId") UUID id) {
        return (SystemCategory)this.systemCategoriesService.get(id);
    }

    @PostMapping
    @AuditAction(auditAction="Create system category with name {{#systemCategories.getName()}}")
    public SystemCategory createSystemCategory(@RequestBody SystemCategoryImpl systemCategories) {
        Preconditions.checkNotNull((Object)systemCategories.getName(), (Object)"System category name can't be empty");
        return this.systemCategoriesService.create(systemCategories.getName(), systemCategories.getDescription());
    }

    @PutMapping
    @AuditAction(auditAction="Update system category with id {{#systemCategories.getId()}} and name {{#systemCategories.getName()}}")
    public SystemCategory updateSystemCategory(@RequestBody SystemCategoryImpl systemCategories) {
        Preconditions.checkNotNull((Object)systemCategories.getId(), (Object)"System category id can't be empty");
        Preconditions.checkNotNull((Object)systemCategories.getName(), (Object)"System category name  can't be empty");
        return this.systemCategoriesService.update(systemCategories.getId(), systemCategories.getName(), systemCategories.getDescription());
    }

    @DeleteMapping(value={"/{systemCategoryId}"})
    @AuditAction(auditAction="Delete system category by id {{#id.toString()}}")
    public void deleteCategory(@PathVariable(value="systemCategoryId") UUID id) {
        this.systemCategoriesService.delete(id);
    }
}

