/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.enums.MdcField;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.model.utils.View;
import org.qubership.atp.environments.repo.impl.ContextRepository;
import org.qubership.atp.environments.service.direct.ConcurrentModificationService;
import org.qubership.atp.environments.service.direct.EnvironmentService;
import org.qubership.atp.environments.service.direct.SystemService;
import org.qubership.atp.environments.service.rest.server.dto.EnvironmentDto;
import org.qubership.atp.environments.service.rest.server.request.ValidateTaToolsRequest;
import org.qubership.atp.environments.service.rest.server.response.ValidateTaToolsResponse;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api"})
@RestController
public class ToolController {
    private final EnvironmentService environmentService;
    private final SystemService systemService;
    private final ConcurrentModificationService concurrentModificationService;
    private final ContextRepository contextRepository;
    private final UUID categoryId = Constants.Environment.Category.TOOL;

    @Autowired
    public ToolController(EnvironmentService service, SystemService systemService, ConcurrentModificationService concurrentModificationService, ContextRepository contextRepository) {
        this.environmentService = service;
        this.systemService = systemService;
        this.concurrentModificationService = concurrentModificationService;
        this.contextRepository = contextRepository;
    }

    @GetMapping(value={"/tools"})
    @AuditAction(auditAction="Get all TA Tools")
    public List<Environment> getAll() {
        return this.environmentService.getAll(this.categoryId);
    }

    @GetMapping(value={"/tools/{environmentId}"})
    @AuditAction(auditAction="Get TA Tool by tool id {{#environmentId.toString()}}")
    public Environment getEnvironment(@PathVariable UUID environmentId) {
        return (Environment)this.environmentService.get(environmentId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'READ')")
    @GetMapping(value={"/tools/{environmentId}/systems"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get tool systems by tool id {{#environmentId.toString()}}")
    public List<System> getToolSystems(@PathVariable(value="environmentId") UUID environmentId, @RequestParam(value="system_type", required=false) String systemType) {
        MdcUtils.put((String)MdcField.ENVIRONMENT_ID.toString(), (UUID)environmentId);
        if (systemType != null) {
            return this.environmentService.getSystems(environmentId, systemType);
        }
        return this.environmentService.getSystems(environmentId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).SYSTEM.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'READ')")
    @GetMapping(value={"/v2/tools/{environmentId}/systems"})
    @JsonView(value={View.FullVer2.class})
    @AuditAction(auditAction="(V2 API) Get TA tool system by tool id {{#environmentId.toString()}}")
    public Collection<System> getSystemV2(@PathVariable(value="environmentId") UUID environmentId, @RequestParam(value="system_type", required=false) String systemType) {
        MdcUtils.put((String)MdcField.ENVIRONMENT_ID.toString(), (UUID)environmentId);
        this.contextRepository.getContext().setFieldsToUnfold(new String[]{"environments", "connections", "systemCategory"});
        if (systemType != null) {
            return this.environmentService.getSystemsV2(environmentId, systemType);
        }
        return this.environmentService.getSystemsV2(environmentId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).TA_TOOL.getName(),#environmentDto.getProjectId(),'CREATE')")
    @PostMapping(value={"/tools"})
    @AuditAction(auditAction="Create tool with id {{#environmentId.toString()}}")
    public Environment createTool(@RequestBody EnvironmentDto environmentDto) {
        return this.environmentService.create(environmentDto.getProjectId(), environmentDto.getName(), environmentDto.getGraylogName(), environmentDto.getDescription(), environmentDto.getSsmSolutionAlias(), environmentDto.getSsmInstanceAlias(), environmentDto.getConsulEgressConfigPath(), this.categoryId, environmentDto.getTags());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).TA_TOOL.getName(),#environmentDto.getProjectId(),'CREATE')")
    @PostMapping(value={"/tools/{environmentId}/copy"})
    @AuditAction(auditAction="Copy tool with id {{#environmentId.toString()}}")
    public Environment copyTool(@PathVariable(value="environmentId") UUID environmentId, @RequestBody EnvironmentDto environmentDto) {
        return this.environmentService.copy(environmentId, environmentDto.getProjectId(), environmentDto.getName(), environmentDto.getGraylogName(), environmentDto.getDescription(), environmentDto.getSsmSolutionAlias(), environmentDto.getSsmInstanceAlias(), environmentDto.getConsulEgressConfigPath(), this.categoryId, environmentDto.getTags());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).TA_TOOL.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'UPDATE')")
    @GetMapping(value={"/tools/{environmentId}/version"})
    @AuditAction(auditAction="Update all system versions in TA Tool by tool id {{#environmentId.toString()}}")
    public ResponseEntity<List<System>> updateVersion(@PathVariable(value="environmentId") UUID environmentId) {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(this.systemService.updateVersionByEnvironmentId(environmentId));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).TA_TOOL.getName(),#environmentDto.getProjectId(),'UPDATE')")
    @PutMapping(value={"/tools"})
    @AuditAction(auditAction="Update tool by tool id {{#environmentDto.id.toString()}}")
    public ResponseEntity updateTool(@RequestBody EnvironmentDto environmentDto) {
        Preconditions.checkNotNull((Object)environmentDto.getId(), (Object)"Tool group id can't be empty");
        MdcUtils.put((String)MdcField.ENVIRONMENT_ID.toString(), (UUID)environmentDto.getId());
        Preconditions.checkNotNull((Object)environmentDto.getName(), (Object)"Tool group name can't be empty");
        HttpStatus status = this.concurrentModificationService.getConcurrentModificationHttpStatus(environmentDto.getId(), environmentDto.getModified(), this.environmentService);
        this.environmentService.update(environmentDto.getId(), environmentDto.getName(), environmentDto.getGraylogName(), environmentDto.getDescription(), environmentDto.getSsmSolutionAlias(), environmentDto.getSsmInstanceAlias(), environmentDto.getConsulEgressConfigPath(), environmentDto.getProjectId(), this.categoryId, environmentDto.getTags());
        return ResponseEntity.status((HttpStatus)status).body((Object)"");
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).TA_TOOL.getName(),#validateTaToolsRequest.getProjectId(),'READ')")
    @PostMapping(value={"/tools/validate"})
    public ResponseEntity<ValidateTaToolsResponse> validateTaTools(@RequestBody ValidateTaToolsRequest validateTaToolsRequest) {
        return ResponseEntity.ok((Object)this.environmentService.validateTaTools(validateTaToolsRequest));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).TA_TOOL.getName(),@environmentService.getProjectIdByEnvironmentId(#environmentId),'DELETE')")
    @DeleteMapping(value={"/tools/{environmentId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete tool by tool id {{#environmentId.toString()}}")
    public void deleteTool(@PathVariable(value="environmentId") UUID environmentId) {
        this.environmentService.delete(environmentId);
    }
}

