/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.model.UpdateEvent;
import org.qubership.atp.environments.model.impl.UpdateEventImpl;
import org.qubership.atp.environments.service.direct.UpdateEventService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/updateEvents"})
@RestController
public class UpdateEventController {
    private final UpdateEventService updateEventService;

    @Autowired
    public UpdateEventController(UpdateEventService service) {
        this.updateEventService = service;
    }

    @GetMapping(value={"/subscription/{subscriptionId}/entity/{entityId}"})
    @AuditAction(auditAction="Get update event by subscription id {{#subscriptionId.toString()}}")
    public UpdateEvent getUpdateEvent(@PathVariable(value="subscriptionId") UUID subscriptionId, @PathVariable(value="entityId") UUID entityId) {
        return this.updateEventService.get(subscriptionId, entityId);
    }

    @GetMapping(value={"/subscription/{subscriptionId}"})
    @AuditAction(auditAction="Get subscription update event by subscription id {{#subscriptionId.toString()}}")
    public UpdateEvent getSubscriptionUpdateEvents(@PathVariable(value="subscriptionId") UUID subscriptionId) {
        return this.updateEventService.getSubscriptionUpdateEvents(subscriptionId);
    }

    @GetMapping(value={"/entity/{entityId}"})
    @AuditAction(auditAction="Get entity events by entity id {{#entityId.toString()}}")
    public UpdateEvent getEntityEvents(@PathVariable(value="entityId") UUID entityId) {
        return this.updateEventService.getEntityUpdateEvents(entityId);
    }

    @GetMapping
    @AuditAction(auditAction="Get all update events")
    public List<UpdateEvent> getAll() {
        return this.updateEventService.getAll();
    }

    @PostMapping
    @AuditAction(auditAction="Create entity event with subscription id {{#updateEvent.getSubscriptionId()}}")
    public UpdateEvent create(@RequestBody UpdateEventImpl updateEvent) {
        return this.updateEventService.create(updateEvent.getSubscriptionId(), updateEvent.getEntityId(), updateEvent.getTagList(), updateEvent.getStatus(), updateEvent.getEntityType());
    }

    @PutMapping(value={"/subscription/{subscriptionId}/entity/{entityId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Update entity event with subscription id {{#updateEvent.getSubscriptionId()}}")
    public void update(@RequestBody UpdateEventImpl updateEvent) {
        Preconditions.checkNotNull((Object)updateEvent.getEntityId(), (Object)"Entity id can't be empty");
        Preconditions.checkNotNull((Object)updateEvent.getSubscriptionId(), (Object)"Subscription id can't be empty");
        this.updateEventService.update(updateEvent.getSubscriptionId(), updateEvent.getEntityId(), updateEvent.getTagList(), updateEvent.getStatus(), updateEvent.getEntityType());
    }

    @DeleteMapping(value={"/subscription/{subscriptionId}/entity/{entityId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete entity event with subscription id {{#subscriptionId.toString()}}")
    public void delete(@PathVariable(value="subscriptionId") UUID subscriptionId, @PathVariable(value="entityId") UUID entityId) {
        this.updateEventService.delete(subscriptionId, entityId);
    }
}

