/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.dto;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.impl.AbstractCreatedModified;

public class ConnectionDto
extends AbstractCreatedModified
implements Serializable {
    static final long serialVersionUID = 42L;
    private UUID systemId;
    private ConnectionParameters parameters;
    private UUID sourceTemplateId;
    private String connectionType;
    private UUID projectId;
    private List<String> services;

    public ConnectionDto(UUID id, String name, UUID systemId, ConnectionParameters parameters, UUID sourceTemplateId, String connectionType, Long created, Long modified, List<String> services) {
        this.id = id;
        this.name = name;
        this.systemId = systemId;
        this.parameters = parameters;
        this.sourceTemplateId = sourceTemplateId;
        this.connectionType = connectionType;
        this.created = created;
        this.modified = modified;
        this.services = services;
    }

    public static ConnectionDto convert(Connection connection) {
        return new ConnectionDto(connection.getId(), connection.getName(), connection.getSystemId(), connection.getParameters(), connection.getSourceTemplateId(), connection.getConnectionType(), connection.getCreated(), connection.getModified(), connection.getServices());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionDto)) {
            return false;
        }
        ConnectionDto other = (ConnectionDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$systemId = this.getSystemId();
        UUID other$systemId = other.getSystemId();
        if (this$systemId == null ? other$systemId != null : !((Object)this$systemId).equals(other$systemId)) {
            return false;
        }
        ConnectionParameters this$parameters = this.getParameters();
        ConnectionParameters other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters)) {
            return false;
        }
        UUID this$sourceTemplateId = this.getSourceTemplateId();
        UUID other$sourceTemplateId = other.getSourceTemplateId();
        if (this$sourceTemplateId == null ? other$sourceTemplateId != null : !((Object)this$sourceTemplateId).equals(other$sourceTemplateId)) {
            return false;
        }
        String this$connectionType = this.getConnectionType();
        String other$connectionType = other.getConnectionType();
        if (this$connectionType == null ? other$connectionType != null : !this$connectionType.equals(other$connectionType)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        List<String> this$services = this.getServices();
        List<String> other$services = other.getServices();
        return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectionDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $systemId = this.getSystemId();
        result = result * 59 + ($systemId == null ? 43 : ((Object)$systemId).hashCode());
        ConnectionParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
        UUID $sourceTemplateId = this.getSourceTemplateId();
        result = result * 59 + ($sourceTemplateId == null ? 43 : ((Object)$sourceTemplateId).hashCode());
        String $connectionType = this.getConnectionType();
        result = result * 59 + ($connectionType == null ? 43 : $connectionType.hashCode());
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        List<String> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        return result;
    }

    public ConnectionDto(UUID systemId, ConnectionParameters parameters, UUID sourceTemplateId, String connectionType, UUID projectId, List<String> services) {
        this.systemId = systemId;
        this.parameters = parameters;
        this.sourceTemplateId = sourceTemplateId;
        this.connectionType = connectionType;
        this.projectId = projectId;
        this.services = services;
    }

    public ConnectionDto() {
    }

    public UUID getSystemId() {
        return this.systemId;
    }

    public ConnectionParameters getParameters() {
        return this.parameters;
    }

    public UUID getSourceTemplateId() {
        return this.sourceTemplateId;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setSystemId(UUID systemId) {
        this.systemId = systemId;
    }

    public void setParameters(ConnectionParameters parameters) {
        this.parameters = parameters;
    }

    public void setSourceTemplateId(UUID sourceTemplateId) {
        this.sourceTemplateId = sourceTemplateId;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public String toString() {
        return "ConnectionDto(systemId=" + this.getSystemId() + ", parameters=" + this.getParameters() + ", sourceTemplateId=" + this.getSourceTemplateId() + ", connectionType=" + this.getConnectionType() + ", projectId=" + this.getProjectId() + ", services=" + this.getServices() + ")";
    }
}

