/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.service.rest.server.dto.generated.AlertEventDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.AlertEventImplDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="AlertEventController", description="Alert Event Controller")
public interface AlertEventControllerApi {
    @Operation(operationId="create", summary="create", tags={"alert-event-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertEventDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/alertEvents"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<AlertEventDtoGenerated> create(@Parameter(name="AlertEventImplDtoGenerated", description="") @Valid @RequestBody(required=false) AlertEventImplDtoGenerated var1);

    @Operation(operationId="delete", summary="delete", tags={"alert-event-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/alertEvents/alert/{alertId}/entity/{entityId}"})
    public ResponseEntity<Void> delete(@Parameter(name="alertId", description="alertId", required=true) @PathVariable(value="alertId") UUID var1, @Parameter(name="entityId", description="entityId", required=true) @PathVariable(value="entityId") UUID var2);

    @Operation(operationId="getAlertEvent", summary="getAlertEvent", tags={"alert-event-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertEventDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/alertEvents/alert/{alertId}/entity/{entityId}"}, produces={"application/json"})
    public ResponseEntity<AlertEventDtoGenerated> getAlertEvent(@Parameter(name="alertId", description="alertId", required=true) @PathVariable(value="alertId") UUID var1, @Parameter(name="entityId", description="entityId", required=true) @PathVariable(value="entityId") UUID var2);

    @Operation(operationId="getAll", summary="getAll", tags={"alert-event-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertEventDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/alertEvents"}, produces={"application/json"})
    public ResponseEntity<List<AlertEventDtoGenerated>> getAll();

    @Operation(operationId="update", summary="update", tags={"alert-event-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/alertEvents/alert/{alertId}/entity/{entityId}"}, consumes={"application/json"})
    public ResponseEntity<Void> update(@Parameter(name="alertId", description="alertId", required=true) @PathVariable(value="alertId") UUID var1, @Parameter(name="entityId", description="entityId", required=true) @PathVariable(value="entityId") UUID var2, @Parameter(name="AlertEventImplDtoGenerated", description="") @Valid @RequestBody(required=false) AlertEventImplDtoGenerated var3);
}

