/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.service.rest.server.dto.generated.BaseSearchRequestDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ConnectionDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.CreateSystemDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentFullVer1ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentsWithFilterRequestDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer1ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer2ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemNameViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemTemporaryDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemVersionResponseDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="EnvironmentController", description="Environment Controller")
public interface EnvironmentControllerApi {
    @Operation(operationId="copy", summary="copy", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments/{environmentId}/copy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentDtoGenerated> copy(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="EnvironmentDtoDtoGenerated", description="") @Valid @RequestBody(required=false) EnvironmentDtoDtoGenerated var2);

    @Operation(operationId="createEnvironment", summary="createEnvironment", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentDtoGenerated> createEnvironment(@Parameter(name="EnvironmentDtoDtoGenerated", description="") @Valid @RequestBody(required=false) EnvironmentDtoDtoGenerated var1);

    @Operation(operationId="createSystem", summary="createSystem", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments/{environmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<SystemDtoGenerated> createSystem(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="CreateSystemDtoDtoGenerated", description="") @Valid @RequestBody(required=false) CreateSystemDtoDtoGenerated var2);

    @Operation(operationId="deleteEnvironment", summary="delete", tags={"environment-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/environments/{environmentId}"})
    public ResponseEntity<Void> deleteEnvironment(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="detailedUpdateVersion", summary="detailedUpdateVersion", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemVersionResponseDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v2/environments/{environmentId}/version"}, produces={"application/json"})
    public ResponseEntity<List<SystemVersionResponseDtoGenerated>> detailedUpdateVersion(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="findBySearchRequest", summary="findBySearchRequest", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<EnvironmentDtoGenerated>> findBySearchRequest(@Parameter(name="BaseSearchRequestDtoGenerated", description="searchRequest", required=true) @Valid @RequestBody BaseSearchRequestDtoGenerated var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getAll", summary="getAll", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentFullVer1ViewDtoGenerated>> getAll(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getEnvironment", summary="getEnvironment", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}"}, produces={"application/json"})
    public ResponseEntity<EnvironmentFullVer1ViewDtoGenerated> getEnvironment(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getEnvironmentConnections", summary="getEnvironmentConnections", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/connections"}, produces={"application/json"})
    public ResponseEntity<List<ConnectionDtoGenerated>> getEnvironmentConnections(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="getEnvironmentNameById", summary="getName", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/name"}, produces={"text/plain"})
    public ResponseEntity<String> getEnvironmentNameById(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="getEnvironmentSystems", summary="getSystems", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/systems"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer1ViewDtoGenerated>> getEnvironmentSystems(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="system_type", description="system_type") @Valid @RequestParam(value="system_type", required=false) String var2, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="getEnvironmentTsg3", summary="Returns all systems with updated versions under environment", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/systems/update-versions"}, produces={"application/json"})
    public ResponseEntity<EnvironmentFullVer1ViewDtoGenerated> getEnvironmentTsg3(@Parameter(name="environmentId", description="Id of the environment. Cannot be empty.", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getEnvironmentsByRequest", summary="getEnvironmentsByRequest", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments/filter"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<EnvironmentFullVer1ViewDtoGenerated>> getEnvironmentsByRequest(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1, @Parameter(name="page", description="full") @Valid @RequestParam(value="page", required=false) Long var2, @Parameter(name="size", description="full") @Valid @RequestParam(value="size", required=false) Long var3, @Parameter(name="EnvironmentsWithFilterRequestDtoGenerated", description="") @Valid @RequestBody(required=false) EnvironmentsWithFilterRequestDtoGenerated var4);

    @Operation(operationId="getPublicHtmlVersion", summary="getPublicHtmlVersion", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/public/v1/environments/{environmentIds}/systems/htmlVersions"}, produces={"text/plain"})
    public ResponseEntity<String> getPublicHtmlVersion(@Parameter(name="environmentIds", description="environmentIds", required=true) @PathVariable(value="environmentIds") List<UUID> var1);

    @Operation(operationId="getSystemV2", summary="getSystemV2", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v2/environments/{environmentId}/systems"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer2ViewDtoGenerated>> getSystemV2(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="system_type", description="system_type") @Valid @RequestParam(value="system_type", required=false) String var2, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="getSystemsShort", summary="getSystemsShort", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemNameViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/systems/short"}, produces={"application/json"})
    public ResponseEntity<List<SystemNameViewDtoGenerated>> getSystemsShort(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="temporary", summary="temporary", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments/{environmentId}/temporary"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentFullVer1ViewDtoGenerated> temporary(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2, @Parameter(name="SystemTemporaryDtoDtoGenerated", description="") @Valid @RequestBody(required=false) List<SystemTemporaryDtoDtoGenerated> var3);

    @Operation(operationId="updateEnvironment", summary="update", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/environments"}, consumes={"application/json"})
    public ResponseEntity<Void> updateEnvironment(@Parameter(name="EnvironmentDtoDtoGenerated", description="") @Valid @RequestBody(required=false) EnvironmentDtoDtoGenerated var1);

    @Operation(operationId="updateVersion", summary="updateVersion", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/version"}, produces={"application/json"})
    public ResponseEntity<List<SystemDtoGenerated>> updateVersion(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);
}

