/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.service.rest.server.dto.generated.UpdateEventDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.UpdateEventImplDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="UpdateEventController", description="Update Event Controller")
public interface UpdateEventControllerApi {
    @Operation(operationId="create", summary="create", tags={"update-event-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpdateEventDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/updateEvents"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UpdateEventDtoGenerated> create(@Parameter(name="UpdateEventImplDtoGenerated", description="") @Valid @RequestBody(required=false) UpdateEventImplDtoGenerated var1);

    @Operation(operationId="delete", summary="delete", tags={"update-event-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/updateEvents/subscription/{subscriptionId}/entity/{entityId}"})
    public ResponseEntity<Void> delete(@Parameter(name="subscriptionId", description="subscriptionId", required=true) @PathVariable(value="subscriptionId") UUID var1, @Parameter(name="entityId", description="entityId", required=true) @PathVariable(value="entityId") UUID var2);

    @Operation(operationId="getAll", summary="getAll", tags={"update-event-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpdateEventDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/updateEvents"}, produces={"application/json"})
    public ResponseEntity<List<UpdateEventDtoGenerated>> getAll();

    @Operation(operationId="getEntityEvents", summary="getEntityEvents", tags={"update-event-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpdateEventDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/updateEvents/entity/{entityId}"}, produces={"application/json"})
    public ResponseEntity<UpdateEventDtoGenerated> getEntityEvents(@Parameter(name="entityId", description="entityId", required=true) @PathVariable(value="entityId") UUID var1);

    @Operation(operationId="getSubscriptionUpdateEvents", summary="getSubscriptionUpdateEvents", tags={"update-event-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpdateEventDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/updateEvents/subscription/{subscriptionId}"}, produces={"application/json"})
    public ResponseEntity<UpdateEventDtoGenerated> getSubscriptionUpdateEvents(@Parameter(name="subscriptionId", description="subscriptionId", required=true) @PathVariable(value="subscriptionId") UUID var1);

    @Operation(operationId="getUpdateEvent", summary="getUpdateEvent", tags={"update-event-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpdateEventDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/updateEvents/subscription/{subscriptionId}/entity/{entityId}"}, produces={"application/json"})
    public ResponseEntity<UpdateEventDtoGenerated> getUpdateEvent(@Parameter(name="subscriptionId", description="subscriptionId", required=true) @PathVariable(value="subscriptionId") UUID var1, @Parameter(name="entityId", description="entityId", required=true) @PathVariable(value="entityId") UUID var2);

    @Operation(operationId="update", summary="update", tags={"update-event-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/updateEvents/subscription/{subscriptionId}/entity/{entityId}"}, consumes={"application/json"})
    public ResponseEntity<Void> update(@Parameter(name="subscriptionId", description="subscriptionId", required=true) @PathVariable(value="subscriptionId") UUID var1, @Parameter(name="entityId", description="entityId", required=true) @PathVariable(value="entityId") UUID var2, @Parameter(name="UpdateEventImplDtoGenerated", description="") @Valid @RequestBody(required=false) UpdateEventImplDtoGenerated var3);
}

