/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.utils;

import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.qubership.atp.environments.service.direct.JaversSnapshotService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class JobRunner {
    private static final String UTC_TIMEZONE = "UTC";
    private final JaversSnapshotService javersSnapshotService;
    private final ThreadPoolTaskExecutor archiveJobExecutor;
    @Value(value="${atp-environments.last.revision.count}")
    private Integer lastRevisionCount;

    public JobRunner(JaversSnapshotService javersSnapshotService, ThreadPoolTaskExecutor archiveJobExecutor) {
        this.javersSnapshotService = javersSnapshotService;
        this.archiveJobExecutor = archiveJobExecutor;
    }

    @Scheduled(cron="${atp-environments.archive.cron.expression}", zone="UTC")
    @SchedulerLock(name="${atp-environments.archive.job.name}", lockAtMostFor="12h", lockAtLeastFor="1h")
    public void run() {
        this.javersSnapshotService.deleteTerminatedSnapshots();
        this.javersSnapshotService.getGlobalIdAndCount(this.lastRevisionCount).stream().map(response -> () -> this.javersSnapshotService.getOld(response.getGlobalId(), response.getCount() - (long)this.lastRevisionCount.intValue()).forEach(snapshot -> this.javersSnapshotService.deleteOldAndUpdateAsInitial(snapshot.getVersion(), snapshot.getGlobalId(), snapshot.getCommitId()))).forEach(arg_0 -> ((ThreadPoolTaskExecutor)this.archiveJobExecutor).execute(arg_0));
    }
}

