/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.utils.cloud;

import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.environments.errorhandling.clients.EnvironmentOpenshiftDeploymentConfigsFetchException;
import org.qubership.atp.environments.errorhandling.clients.EnvironmentOpenshiftProjectFetchException;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.service.rest.server.response.ShortExternalService;
import org.qubership.atp.environments.utils.cloud.ExternalCloudClient;
import org.qubership.atp.environments.utils.cloud.model.CloudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OpenshiftClient
extends ExternalCloudClient {
    private static final Logger log = LoggerFactory.getLogger(OpenshiftClient.class);
    private IClient client;

    @Override
    public void configure(ConnectionParameters connectionParameters) {
        String serverUrl = (String)connectionParameters.get((Object)"url");
        String login = (String)connectionParameters.get((Object)"login");
        String password = (String)connectionParameters.get((Object)"password");
        String token = (String)connectionParameters.get((Object)"token");
        this.namespace = (String)connectionParameters.get((Object)"project");
        this.client = !StringUtils.isEmpty((Object)token) ? new ClientBuilder(serverUrl).usingToken(token).build() : new ClientBuilder(serverUrl).withUserName(login).withPassword(password).build();
    }

    public Set<String> getImageSet() {
        HashSet<String> images = new HashSet<String>();
        List<IDeploymentConfig> deploymentConfigList = this.readDeploymentConfigs(this.namespace);
        deploymentConfigList.forEach(iDeploymentConfig -> images.addAll(iDeploymentConfig.getImages()));
        return images;
    }

    public List<IDeploymentConfig> readDeploymentConfigs(String namespace) {
        List list;
        String kind = "DeploymentConfig";
        try {
            list = this.client.list(kind, namespace);
        }
        catch (Exception e) {
            log.error("Failed to fetch Openshift deployment configs");
            throw new EnvironmentOpenshiftDeploymentConfigsFetchException();
        }
        return list;
    }

    public List<IRoute> getRoutes(String openshiftProject) {
        IProject projectOpenShift;
        try {
            projectOpenShift = (IProject)this.client.get("Project", openshiftProject, openshiftProject);
        }
        catch (Exception e) {
            log.error("Failed to fetch Openshift project: {}", (Object)openshiftProject, (Object)e);
            throw new EnvironmentOpenshiftProjectFetchException(openshiftProject);
        }
        return projectOpenShift.getProject().getResources("Route");
    }

    public String getRouteUrl(String serviceName, List<IRoute> routes) {
        if (StringUtils.isEmpty((Object)serviceName)) {
            return "";
        }
        return routes.stream().map(route -> {
            if (route.getServiceName().equals(serviceName)) {
                String scheme = route.getTLSConfig() == null ? "http" : "https";
                return String.format("%s://%s", scheme, route.getHost());
            }
            return "";
        }).collect(Collectors.joining());
    }

    public List<IService> getServices(String openshiftProject) {
        IProject projectOpenShift;
        try {
            projectOpenShift = (IProject)this.client.get("Project", openshiftProject, openshiftProject);
        }
        catch (Exception e) {
            log.error("Failed to fetch Openshift project: {}", (Object)openshiftProject, (Object)e);
            throw new EnvironmentOpenshiftProjectFetchException(openshiftProject);
        }
        return projectOpenShift.getProject().getResources("Service");
    }

    @Override
    public List<ShortExternalService> getShortServices() {
        return this.getServices(this.namespace).stream().map(service -> new ShortExternalService((String)service.getMetadata().get("uid"), (String)service.getMetadata().get("name"))).collect(Collectors.toList());
    }

    private List<IService> getServicesList() {
        List serviceList = this.client.list("Service", this.namespace);
        return serviceList.stream().filter(service -> Objects.nonNull(service.getMetadata()) && !StringUtils.isEmpty(service.getMetadata().get("uid"))).collect(Collectors.toList());
    }

    private Map<String, String> getRoutesMap() {
        HashMap<String, String> routesMap = new HashMap<String, String>();
        this.getRoutes(this.namespace).forEach(route -> routesMap.put(route.getServiceName(), route.getURL()));
        return routesMap;
    }

    @Override
    public List<CloudService> getServicesByExistingServices(List<System> existingServices) {
        List<IService> serviceList = this.getServicesList();
        Map<String, String> routeMap = this.getRoutesMap();
        Map<String, IService> servicesMapById = this.getServicesMapById(serviceList);
        Map<String, IService> servicesMapByName = this.getServicesMapByName(serviceList);
        ArrayList<CloudService> processedServiceList = new ArrayList<CloudService>();
        for (System existingService : existingServices) {
            String serviceName;
            IService externalService;
            if (Objects.nonNull(existingService.getExternalId()) && servicesMapById.containsKey(existingService.getExternalId().toString())) {
                externalService = servicesMapById.get(existingService.getExternalId().toString());
            } else {
                if (!Objects.nonNull(existingService.getExternalName()) || !servicesMapByName.containsKey(existingService.getExternalName())) continue;
                externalService = servicesMapByName.get(existingService.getExternalName());
            }
            if ((serviceName = externalService.getName()) == null) continue;
            processedServiceList.add(this.createCloudService(externalService, routeMap.get(serviceName)));
        }
        return processedServiceList;
    }

    private Map<String, IService> getServicesMapById(List<IService> serviceList) {
        return serviceList.stream().collect(Collectors.toMap(service -> (String)service.getMetadata().get("uid"), service -> service));
    }

    private Map<String, IService> getServicesMapByName(List<IService> serviceList) {
        return serviceList.stream().collect(Collectors.toMap(IResource::getName, service -> service));
    }

    private CloudService createCloudService(IService externalService, String route) {
        CloudService service = new CloudService();
        service.setName(externalService.getName());
        service.setId(UUID.fromString((String)externalService.getMetadata().get("uid")));
        service.setHost(route);
        return service;
    }

    @Override
    public List<CloudService> getServicesByServiceId(List<UUID> existingServiceIds) {
        Map<String, String> routeMap = this.getRoutesMap();
        List<IService> serviceList = this.getServicesList();
        Map<String, IService> servicesMap = this.getServicesMapById(serviceList);
        ArrayList<CloudService> processedServiceList = new ArrayList<CloudService>();
        existingServiceIds.forEach(serviceId -> {
            String serviceName = ((IService)servicesMap.get(serviceId.toString())).getName();
            if (serviceName != null) {
                processedServiceList.add(this.createCloudService((IService)servicesMap.get(serviceId.toString()), (String)routeMap.get(serviceName)));
            }
        });
        return processedServiceList;
    }

    protected static class OpenShiftApiConstants {
        protected static final String ID = "uid";
        protected static final String NAME = "name";

        protected OpenShiftApiConstants() {
        }
    }
}

