/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.validating.factories;

import java.util.Map;
import org.qubership.atp.environments.validating.strategies.ValidationStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidationStrategyFactory {
    public static final String ITF_LITE = "itfLite";
    private final Map<String, ValidationStrategy> strategyMap;

    @Autowired
    public ValidationStrategyFactory(Map<String, ValidationStrategy> strategyMap) {
        this.strategyMap = strategyMap;
    }

    public ValidationStrategy createStrategy(String strategyType) {
        ValidationStrategy strategy = this.strategyMap.get(strategyType);
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Invalid validation strategy type %s", strategyType));
        }
        return strategy;
    }
}

