/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.versioning.model.entities;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.javers.core.metamodel.annotation.TypeName;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.service.direct.SystemCategoriesService;
import org.qubership.atp.environments.versioning.model.entities.AbstractJaversEntity;
import org.qubership.atp.environments.versioning.model.values.ConnectionJ;
import org.qubership.atp.environments.versioning.model.values.ParametersGettingVersionJ;
import org.qubership.atp.environments.versioning.model.values.ServerItfJ;
import org.qubership.atp.environments.versioning.validation.ReferenceExists;
import org.springframework.util.CollectionUtils;

@TypeName(value="System")
public class SystemJ
extends AbstractJaversEntity {
    private String name;
    private String description;
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    private Date modified;
    @ReferenceExists(service=SystemCategoriesService.class, message="system category")
    private UUID systemCategoryId;
    @Nullable
    private Set<ConnectionJ> connections;
    private ParametersGettingVersionJ parametersGettingVersion;
    private ServerItfJ serverItf;

    public SystemJ(System model) {
        super((Identified)model);
        this.name = model.getName();
        this.description = model.getDescription();
        this.modified = model.getModified() == null ? null : new Date(model.getModified());
        this.systemCategoryId = model.getSystemCategoryId();
        if (!CollectionUtils.isEmpty((Collection)model.getConnections())) {
            this.connections = model.getConnections().stream().map(ConnectionJ::new).collect(Collectors.toSet());
        }
        this.parametersGettingVersion = model.getParametersGettingVersion() == null ? null : new ParametersGettingVersionJ(model.getParametersGettingVersion());
        this.serverItf = model.getServerItf() == null ? null : new ServerItfJ(model.getServerItf());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getModified() {
        return this.modified;
    }

    public UUID getSystemCategoryId() {
        return this.systemCategoryId;
    }

    @Nullable
    public Set<ConnectionJ> getConnections() {
        return this.connections;
    }

    public ParametersGettingVersionJ getParametersGettingVersion() {
        return this.parametersGettingVersion;
    }

    public ServerItfJ getServerItf() {
        return this.serverItf;
    }
}

