/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.versioning.service.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.javers.core.Javers;
import org.javers.core.commit.Commit;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.QueryBuilder;
import org.qubership.atp.environments.versioning.service.JaversAuthorProvider;
import org.qubership.atp.environments.versioning.service.JaversService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JaversServiceImpl
implements JaversService {
    private static final Logger log = LoggerFactory.getLogger(JaversServiceImpl.class);
    private static final String USERNAME_PROPERTY_NAME = "Username";
    private final Javers javers;
    private final JaversAuthorProvider authorProvider;
    @Value(value="${atp-environments.javers.enabled}")
    private boolean isJaversEnabled;

    public JaversServiceImpl(Javers javers, JaversAuthorProvider authorProvider) {
        this.javers = javers;
        this.authorProvider = authorProvider;
    }

    @Override
    public Commit commit(Object currentVersion) {
        return this.isJaversEnabled ? this.javers.commit(this.getAuthor(), currentVersion, this.getCommitProperties()) : null;
    }

    @Override
    public CompletableFuture<Commit> commitAsync(Object currentVersion, Executor executor) {
        return this.isJaversEnabled ? this.javers.commitAsync(this.getAuthor(), currentVersion, this.getCommitProperties(), executor) : null;
    }

    @Override
    public Commit commitShallowDelete(Object deleted) {
        return this.isJaversEnabled ? this.javers.commitShallowDelete(this.getAuthor(), deleted, this.getCommitProperties()) : null;
    }

    @Override
    public Commit commitShallowDeleteById(GlobalIdDTO globalId) {
        if (this.isJaversEnabled) {
            if (this.javers.findSnapshots(QueryBuilder.byGlobalId((GlobalIdDTO)globalId).build()).size() == 0) {
                return null;
            }
            return this.javers.commitShallowDeleteById(this.getAuthor(), globalId, this.getCommitProperties());
        }
        return null;
    }

    private String getAuthor() {
        return this.authorProvider.provide();
    }

    private Map<String, String> getCommitProperties() {
        HashMap<String, String> commitProperties = new HashMap<String, String>();
        commitProperties.put(USERNAME_PROPERTY_NAME, this.authorProvider.getUsername());
        return commitProperties;
    }
}

