/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.versioning.validation;

import java.util.Collection;
import java.util.UUID;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.qubership.atp.environments.service.direct.IdentifiedService;
import org.qubership.atp.environments.versioning.validation.ReferenceExists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ReferenceExistsValidator
implements ConstraintValidator<ReferenceExists, Object> {
    private ApplicationContext applicationContext;
    private ReferenceExists annotation;

    @Autowired
    public ReferenceExistsValidator(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void initialize(ReferenceExists constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        Class<? extends IdentifiedService> serviceClass = this.annotation.service();
        IdentifiedService service = (IdentifiedService)this.applicationContext.getBean(serviceClass);
        if (value instanceof Collection) {
            return ((Collection)value).stream().allMatch(service::existsById);
        }
        if (value instanceof UUID) {
            return service.existsById((UUID)value);
        }
        return false;
    }
}

