/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.crypt;

import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.crypt.Constants;

public final class CryptoTools {
    public static String maskEncryptedData(String text, String mask) {
        if (StringUtils.isEmpty((String)text) || !text.contains("{ENC}")) {
            return text;
        }
        return text.replaceAll(CryptoTools.getTemplateRegexp(), mask);
    }

    public static String maskEncryptedData(String text) {
        return CryptoTools.maskEncryptedData(text, "********");
    }

    public static String getEncryptedMask() {
        return "********";
    }

    public static String getTemplateRegexp() {
        return "\\{ENC\\}(\\{(?<iv>[a-zA-Z0-9\\=\\/\\+]*)\\}){1}(\\{(?<cryptData>[a-zA-Z0-9\\=\\/\\+]+)\\}){1}";
    }

    public static String[] getEncryptedData(String data) {
        Matcher matcher = Constants.TEMPLATE_PATTERN.matcher(data);
        if (!matcher.find()) {
            return null;
        }
        return new String[]{matcher.group("iv"), matcher.group("cryptData")};
    }

    private CryptoTools() {
    }
}

