/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.notification.client;

import java.util.List;
import org.qubership.atp.integration.configuration.model.notification.Message;
import org.qubership.atp.integration.configuration.model.notification.Notification;
import org.qubership.atp.integration.configuration.notification.client.NotificationClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaNotificationClient
implements NotificationClient {
    private static final Logger log = LoggerFactory.getLogger(KafkaNotificationClient.class);
    @Value(value="${kafka.notification.topic.name}")
    private final String topicName;
    private final KafkaTemplate<String, Message> kafkaTemplate;

    @Override
    public void sendNotification(Notification notification) {
        Message message = new Message(notification);
        try {
            log.info("Send notification to kafka");
            this.kafkaTemplate.send(this.topicName, (Object)message);
        }
        catch (Exception e) {
            log.error("Sending of notification message to kafka is failed", (Throwable)e);
        }
    }

    @Override
    public void sendNotifications(List<Notification> notifications) {
        log.info("Send notifications. Count: {}", (Object)notifications.size());
        for (Notification notification : notifications) {
            this.sendNotification(notification);
        }
    }

    public KafkaNotificationClient(String topicName, KafkaTemplate<String, Message> kafkaTemplate) {
        this.topicName = topicName;
        this.kafkaTemplate = kafkaTemplate;
    }
}

