/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.model.impl;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.impl.AbstractCreatedModified;

public class ConnectionImpl
extends AbstractCreatedModified
implements Connection {
    private UUID systemId;
    private ConnectionParameters parameters;
    private UUID sourceTemplateId;
    private String connectionType;
    private List<String> services;
    private UUID sourceId;

    public ConnectionImpl() {
    }

    public ConnectionImpl(UUID uuid, String name, String description, @Nonnull ConnectionParameters parameters, Long created, UUID createdBy, Long modified, UUID modifiedBy, @Nonnull UUID systemId, String connectionType, @Nonnull UUID sourceTemplateId, List<String> services, UUID sourceId) {
        this.setId(uuid);
        this.setName(name);
        this.setDescription(description);
        this.setParameters(parameters);
        this.setCreated(created);
        this.setCreatedBy(createdBy);
        this.setModified(modified);
        this.setModifiedBy(modifiedBy);
        this.setSystemId(systemId);
        this.setConnectionType(connectionType);
        this.setSourceTemplateId(sourceTemplateId);
        this.setServices(services);
        this.setSourceId(sourceId);
    }

    @Override
    @Nonnull
    public UUID getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(@Nonnull UUID systemId) {
        this.systemId = systemId;
    }

    @Override
    @Nonnull
    public ConnectionParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(@Nonnull ConnectionParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public List<String> getServices() {
        return this.services;
    }

    @Override
    public void setServices(List<String> services) {
        this.services = services;
    }

    @Override
    @Nullable
    public UUID getSourceTemplateId() {
        return this.sourceTemplateId;
    }

    @Override
    public void setSourceTemplateId(@Nullable UUID sourceTemplateId) {
        this.sourceTemplateId = sourceTemplateId;
    }

    @Override
    @Nullable
    public String getConnectionType() {
        return this.connectionType;
    }

    @Override
    public void setConnectionType(@Nullable String connectionType) {
        this.connectionType = connectionType;
    }

    @Override
    public UUID getSourceId() {
        return this.sourceId;
    }

    @Override
    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public static ConnectionImplBuilder builder() {
        return new ConnectionImplBuilder();
    }

    public static class ConnectionImplBuilder {
        private UUID uuid;
        private String name;
        private String description;
        private ConnectionParameters parameters;
        private Long created;
        private UUID createdBy;
        private Long modified;
        private UUID modifiedBy;
        private UUID systemId;
        private String connectionType;
        private UUID sourceTemplateId;
        private List<String> services;
        private UUID sourceId;

        ConnectionImplBuilder() {
        }

        public ConnectionImplBuilder uuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public ConnectionImplBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConnectionImplBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ConnectionImplBuilder parameters(@Nonnull ConnectionParameters parameters) {
            if (parameters == null) {
                throw new NullPointerException("parameters is marked non-null but is null");
            }
            this.parameters = parameters;
            return this;
        }

        public ConnectionImplBuilder created(Long created) {
            this.created = created;
            return this;
        }

        public ConnectionImplBuilder createdBy(UUID createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public ConnectionImplBuilder modified(Long modified) {
            this.modified = modified;
            return this;
        }

        public ConnectionImplBuilder modifiedBy(UUID modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this;
        }

        public ConnectionImplBuilder systemId(@Nonnull UUID systemId) {
            if (systemId == null) {
                throw new NullPointerException("systemId is marked non-null but is null");
            }
            this.systemId = systemId;
            return this;
        }

        public ConnectionImplBuilder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public ConnectionImplBuilder sourceTemplateId(@Nonnull UUID sourceTemplateId) {
            if (sourceTemplateId == null) {
                throw new NullPointerException("sourceTemplateId is marked non-null but is null");
            }
            this.sourceTemplateId = sourceTemplateId;
            return this;
        }

        public ConnectionImplBuilder services(List<String> services) {
            this.services = services;
            return this;
        }

        public ConnectionImplBuilder sourceId(UUID sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public ConnectionImpl build() {
            return new ConnectionImpl(this.uuid, this.name, this.description, this.parameters, this.created, this.createdBy, this.modified, this.modifiedBy, this.systemId, this.connectionType, this.sourceTemplateId, this.services, this.sourceId);
        }

        public String toString() {
            return "ConnectionImpl.ConnectionImplBuilder(uuid=" + this.uuid + ", name=" + this.name + ", description=" + this.description + ", parameters=" + this.parameters + ", created=" + this.created + ", createdBy=" + this.createdBy + ", modified=" + this.modified + ", modifiedBy=" + this.modifiedBy + ", systemId=" + this.systemId + ", connectionType=" + this.connectionType + ", sourceTemplateId=" + this.sourceTemplateId + ", services=" + this.services + ", sourceId=" + this.sourceId + ")";
        }
    }
}

