/*
 * Decompiled with CFR 0.152.
 */
package j2html.tags;

import j2html.Config;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.Text;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ContainerTag
extends Tag<ContainerTag> {
    private List<DomContent> children = new ArrayList<DomContent>();

    public ContainerTag(String tagName) {
        super(tagName);
    }

    public ContainerTag with(DomContent child) {
        if (this == child) {
            throw new RuntimeException("Cannot append a tag to itself.");
        }
        if (child == null) {
            return this;
        }
        this.children.add(child);
        return this;
    }

    public ContainerTag condWith(boolean condition, DomContent child) {
        return condition ? this.with(child) : this;
    }

    public ContainerTag with(Iterable<? extends DomContent> children) {
        if (children != null) {
            for (DomContent domContent : children) {
                this.with(domContent);
            }
        }
        return this;
    }

    public ContainerTag condWith(boolean condition, Iterable<? extends DomContent> children) {
        return condition ? this.with(children) : this;
    }

    public ContainerTag with(DomContent ... children) {
        for (DomContent child : children) {
            this.with(child);
        }
        return this;
    }

    public ContainerTag condWith(boolean condition, DomContent ... children) {
        return condition ? this.with(children) : this;
    }

    public ContainerTag withText(String text) {
        return this.with((DomContent)new Text(text));
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public String renderFormatted() {
        try {
            return this.renderFormatted(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String renderFormatted(int lvl) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.renderOpenTag(sb, null);
        if ("pre".equals(this.tagName) || "textarea".equals(this.tagName)) {
            return this.render() + "\n";
        }
        sb.append("\n");
        if (!this.children.isEmpty()) {
            for (DomContent c : this.children) {
                ++lvl;
                if (c instanceof ContainerTag) {
                    sb.append(Config.indenter.indent(lvl, ((ContainerTag)c).renderFormatted(lvl)));
                } else {
                    sb.append(Config.indenter.indent(lvl, c.render())).append("\n");
                }
                --lvl;
            }
        }
        sb.append(Config.indenter.indent(lvl, ""));
        this.renderCloseTag(sb);
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void renderModel(Appendable writer, Object model) throws IOException {
        this.renderOpenTag(writer, model);
        if (this.children != null && !this.children.isEmpty()) {
            for (DomContent child : this.children) {
                child.renderModel(writer, model);
            }
        }
        this.renderCloseTag(writer);
    }
}

