/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.converter;

import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.qubership.atp.ei.ntt.converter.ConverterConstants;
import org.qubership.atp.ei.ntt.converter.ReadOnlyTextJsMapping;
import org.qubership.atp.ei.ntt.converter.TextAppender;
import org.qubership.atp.ei.ntt.converter.TextToMiConverter;
import org.qubership.atp.ei.ntt.converter.TextType;
import org.qubership.atp.ei.ntt.model.ModelItem;
import org.qubership.atp.ei.ntt.model.Reference;
import org.qubership.atp.ei.ntt.model.Template;
import org.qubership.atp.ei.ntt.model.TreeNode;
import org.qubership.atp.ei.ntt.model.enums.ModelItemType;
import org.qubership.atp.ei.ntt.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelItemTextConverter {
    private static final Logger log = LoggerFactory.getLogger(ModelItemTextConverter.class);
    private static ModelItemTextConverter instance;
    private static HashBiMap<TreeNode, TreeNode> changesMapForScopeItems;

    private ModelItemTextConverter() {
        changesMapForScopeItems = HashBiMap.create();
    }

    public static ModelItemTextConverter getInstance() {
        if (instance == null) {
            instance = new ModelItemTextConverter();
        }
        return instance;
    }

    public static HashBiMap<TreeNode, TreeNode> getChangesMapForScope() {
        return changesMapForScopeItems;
    }

    String getPrefix(ModelItemType miEnum) {
        return ConverterConstants.PREFIXES[miEnum.ordinal()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildrenFromText(ModelItem parent, BufferedReader reader, boolean isTemplatesTree) {
        if (parent == null || reader == null || parent.getModelItemType().isLeaf()) {
            return;
        }
        if (parent instanceof Reference) {
            parent = parent.getTemplate();
        }
        if (parent instanceof Template) {
            parent = ((Template)parent).getModelItem();
        }
        TextToMiConverter converter = new TextToMiConverter(this, parent, isTemplatesTree);
        try {
            String line = reader.readLine();
            while (line != null) {
                converter.appendMi(line.trim());
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            log.error("Can not convert text to ModelItem", (Throwable)e);
            return;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        converter.flush();
    }

    public void setChildrenFromText(ModelItem parent, File file, boolean isTemplatesTree) {
        this.setChildrenFromText(parent, CommonUtils.getReaderForFile(file), isTemplatesTree);
    }

    public ReadOnlyTextJsMapping convertMiToText(ModelItem modelItem, TextType type) {
        ReadOnlyTextJsMapping mapping = new ReadOnlyTextJsMapping();
        ModelItemType miEnum = modelItem.getModelItemType();
        TextAppender ta = new TextAppender(this, type, miEnum.next(), mapping);
        List children = modelItem.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (i != 0) {
                mapping.appendNewLine();
            }
            ta.appendModelItem((ModelItem)children.get(i), false);
        }
        return mapping;
    }

    public ReadOnlyTextJsMapping convertTemplateToText(ModelItem modelItem, TextType type) {
        ReadOnlyTextJsMapping mapping = new ReadOnlyTextJsMapping();
        TextAppender ta = new TextAppender(this, type, ModelItemType.ACTION, mapping);
        List children = modelItem.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ModelItemType miEnum = ((ModelItem)children.get(i)).getModelItemType();
            ta.setCurrentModelItemType(miEnum);
            ta.clearIndent();
            if (i != 0) {
                mapping.appendNewLine();
            }
            ta.appendModelItem((ModelItem)children.get(i), true);
        }
        return mapping;
    }
}

