/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.model.impl;

import java.util.Collections;
import java.util.List;
import org.qubership.atp.ei.ntt.model.Cloneable;
import org.qubership.atp.ei.ntt.model.TestAction;
import org.qubership.atp.ei.ntt.model.TreeNode;
import org.qubership.atp.ei.ntt.model.enums.ModelItemType;
import org.qubership.atp.ei.ntt.model.impl.AbstractModelItem;
import org.qubership.atp.ei.ntt.utils.CommonUtils;

public class TestActionModel
extends AbstractModelItem
implements TestAction,
Cloneable<TestActionModel> {
    private String actionId;

    public TestActionModel() {
    }

    public TestActionModel(String name) {
        this.setName(name);
    }

    public TestActionModel(String name, TestActionModel model) {
        this.setName(name);
        this.actionId = CommonUtils.generateId();
        this.setParent(model.getParent());
        for (String flag : model.getFlags()) {
            this.setFlag(flag, true);
        }
    }

    @Override
    public <T extends TreeNode> List<T> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <T extends TreeNode> void setChildren(List<T> children) {
    }

    @Override
    public String getActionId() {
        return this.actionId;
    }

    @Override
    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    @Override
    public TestActionModel clone() {
        try {
            TestActionModel newTestActionModel = (TestActionModel)super.clone();
            newTestActionModel.setActionId(CommonUtils.generateId());
            return newTestActionModel;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone is not supported for TestActionModel super class", e);
        }
    }

    @Override
    public ModelItemType getModelItemType() {
        return ModelItemType.ACTION;
    }
}

