/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings.model.dal.support;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.qubership.atp.ei.ntt.settings.ReflectionUtils;
import org.qubership.atp.ei.ntt.settings.model.dal.Resource;
import org.qubership.atp.ei.ntt.settings.model.dal.support.DaoFactory;

public class XmlDaoFactory
extends DaoFactory {
    protected static final Logger log = Logger.getLogger(XmlDaoFactory.class);

    @Override
    public <T extends Resource> T load(Class<T> clazz) {
        Resource element = (Resource)ReflectionUtils.getInstance(clazz);
        this.load(element);
        return (T)element;
    }

    @Override
    public <T extends DaoFactory.ElementDal> T load(Resource resource) {
        resource = this.loadResource((DaoFactory.XmlResource)resource);
        T element = this.get((DaoFactory.XmlResource)resource);
        return element;
    }

    @Override
    public <T extends DaoFactory.XmlResource> T loadResource(T resource) {
        log.debug((Object)("Try to load file by path:[" + resource.getFileSettings().getPathToSave() + "]"));
        resource.getStorer().setFilePath(resource.getFileSettings().getPathToSave());
        resource.getStorer().read();
        log.debug((Object)("Successful load file by path:[" + resource.getFileSettings().getPathToSave() + "]"));
        this.parse(resource);
        return resource;
    }

    private <T extends DaoFactory.XmlResource> T parse(T resource) {
        for (DaoFactory.ElementDal element : resource.getChildren()) {
            resource.getAssociable().initAssociations(element);
            element.setResource(resource);
        }
        return resource;
    }

    @Override
    public <T extends DaoFactory.ElementDal> T get(DaoFactory.XmlResource resource) {
        return (T)this.get(resource, ((DaoFactory.ElementDal)resource.getChildren().get(0)).getClass());
    }

    @Override
    @Nullable
    public <T extends DaoFactory.ElementDal> T get(DaoFactory.XmlResource resource, Class<T> clazz) {
        T result = null;
        if (clazz != null) {
            result = resource.getChild(clazz);
        }
        return result;
    }

    @Override
    public <T extends DaoFactory.ElementDal> T set(T element) {
        element.getResource().setChild(element);
        this.set(element.getResource());
        return element;
    }

    @Override
    public <T extends Resource> T set(T resource) {
        for (DaoFactory.ElementDal element : resource.getChildren()) {
            ((DaoFactory.XmlResource)resource).getAssociable().setAssociations(element);
        }
        return resource;
    }

    @Override
    public <T extends DaoFactory.XmlResource> boolean save(T resource) {
        String tab = "\t";
        this.set(resource);
        log.debug((Object)("Try to save file by path:[" + resource.getFileSettings().getPathToSave() + "]"));
        resource.getStorer().setFilePath(resource.getFileSettings().getPathToSave());
        boolean result = resource.getStorer().write();
        if (result) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(resource.getFileSettings().getPathToSave()));
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    String testString = line.replace("\t", "").replace(" ", "");
                    if (testString.isEmpty()) continue;
                    sb.append(line.concat("\n"));
                }
                reader.close();
                PrintWriter out = new PrintWriter(resource.getFileSettings().getPathToSave());
                out.print(sb.toString());
                out.close();
            }
            catch (Exception ex) {
                log.error((Object)("Exception occurred while saving file: " + ex.getMessage()), (Throwable)ex);
                return true;
            }
            log.debug((Object)("Successful save file by path:[" + resource.getFileSettings().getPathToSave() + "]"));
        }
        return result;
    }

    @Override
    public <T extends DaoFactory.ElementDal> boolean save(T element) {
        return this.save((DaoFactory.XmlResource)element.getResource());
    }
}

