/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.RACCallbackGuard;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.jdbc.oracle.rlb.ConnectionsDispatcher;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.Policy;
import oracle.ucp.jdbc.oracle.rlb.PolicyImpl;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle.rlb")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class OracleDatabaseInstanceInfoList {
    private final Instances instances = new Instances();
    private Policy rlbPolicy;
    private final RACManagerImpl m_racMngr;
    private static final String CONNECT_DATA_KEYWORD = "CONNECT_DATA";
    private OracleDatabaseInstanceInfo lastUsedInstanceToGrow;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    public Collection<OracleDatabaseInstanceInfo> getAllInstances() {
        return this.instances.getAllInstances();
    }

    public OracleDatabaseInstanceInfoList(RACManagerImpl racMngr) {
        String sPolicy = null;
        try {
            sPolicy = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() {
                    return System.getProperty("oracle.ucp.jdbc.oracle.rlb.policy");
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleDatabaseInstanceInfoList.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
            this.rlbPolicy = null == sPolicy || "".equals(sPolicy) ? new PolicyImpl() : (Policy)Class.forName(sPolicy).newInstance();
        }
        catch (Exception e) {
            ClioSupport.ilogWarning(null, null, null, null, "unable to use policy class " + sPolicy + ", using default RLB policy instead");
            this.rlbPolicy = new PolicyImpl();
        }
        this.lastUsedInstanceToGrow = null;
        this.m_racMngr = racMngr;
        this.rlbPolicy.plugRLBInfo(this.m_racMngr.rlbMetricsAccumulator);
        this.rlbPolicy.plugConnectionsDispatcher(new ConnectionsDispatcher(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public FailoverablePooledConnection borrowConnection(OracleDatabaseInstanceInfo dbInstance, ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
                return OracleDatabaseInstanceInfoList.this.m_racMngr.getRACCallback().getAvailableConnectionToInstance(cri, new RACInstanceImpl(dbInstance));
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(OracleDatabaseInstanceInfoList.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("borrowConnection", OracleDatabaseInstanceInfo.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    public synchronized void updateDatabaseInstanceInfo(OracleDatabaseInstanceInfo dbInfo, boolean isForFailover, boolean isAddingConnection) {
        int instId;
        Integer instNum = this.instances.getId(dbInfo);
        int n = instId = instNum != null ? instNum : -1;
        if (isForFailover) {
            if (instId != -1) {
                if (isAddingConnection && instId != dbInfo.getId()) {
                    ClioSupport.ilogFinest(null, null, null, null, "name->id mapping out-of-sync, instance=" + dbInfo.getInstanceName() + ", id=" + dbInfo.getId() + ", id-in-table=" + instId);
                    return;
                }
                OracleDatabaseInstanceInfo dbInstance = this.instances.getInstance(instId);
                if (isAddingConnection) {
                    dbInstance.incrementNumberOfConnectionsCount();
                    if (dbInstance.status == 2) {
                        dbInstance.status = 1;
                    }
                } else {
                    dbInstance.decrementNumberOfConnectionsCount();
                }
            } else {
                dbInfo.incrementNumberOfConnectionsCount();
                this.setNamedInstanceUrl(dbInfo, dbInfo.getInstanceName());
                dbInfo.status = 1;
                if (dbInfo.getId() >= 0) {
                    this.instances.add(dbInfo, dbInfo.getId());
                }
            }
        } else if (instId >= 0) {
            OracleDatabaseInstanceInfo dbInstance = this.instances.getInstance(instId);
            dbInstance.setAdvisoryPercent(dbInfo.getAdvisoryPercent());
            dbInstance.flag = dbInfo.flag;
        }
    }

    private void setNamedInstanceUrl(OracleDatabaseInstanceInfo dbInfo, String instanceName) {
        StringBuffer urlBuf = new StringBuffer(this.m_racMngr.getRACCallback().getUrl());
        int keywordIndex = urlBuf.indexOf(CONNECT_DATA_KEYWORD);
        if (keywordIndex == -1) {
            dbInfo.setNamedInstanceUrl(null);
            ClioSupport.ilogFinest(null, null, null, null, "connect data keyword not found");
        } else {
            int equalSignIndex = urlBuf.indexOf("=", keywordIndex + CONNECT_DATA_KEYWORD.length());
            if (equalSignIndex == -1) {
                dbInfo.setNamedInstanceUrl(null);
                ClioSupport.ilogFinest(null, null, null, null, "equal sign was not found");
            } else {
                urlBuf.insert(equalSignIndex + 1, "(INSTANCE_NAME=" + instanceName + ")");
                dbInfo.setNamedInstanceUrl(urlBuf.toString());
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, "instance=" + dbInfo.getInstanceName() + ", namedInstanceUrl=" + urlBuf.toString());
    }

    public boolean isNamedInstanceConnectingAllowed(String instanceName, String dbUniqName, boolean isInstanceAffinityEnabled) {
        int instId;
        RACCallbackGuard cbk = this.m_racMngr.getRACCallback();
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(dbUniqName, instanceName);
        Integer instNum = this.instances.getId(tmpInstance);
        int n = instId = instNum != null ? instNum : -1;
        if (instId < 0) {
            ClioSupport.ilogFinest(null, null, null, null, "instId < 0");
            return false;
        }
        OracleDatabaseInstanceInfo dbInstance = this.instances.getInstance(instId);
        if (dbInstance == null) {
            ClioSupport.ilogFinest(null, null, null, null, "dbInstance is null");
            return false;
        }
        if (dbInstance.status == 1 && dbInstance.flag <= 3) {
            int connNumThreshold;
            ClioSupport.ilogFinest(null, null, null, null, "instance is alive");
            int dbVersion = this.m_racMngr.getDatabaseVersion();
            if (dbVersion >= 11100 || !isInstanceAffinityEnabled) {
                ClioSupport.ilogFinest(null, null, null, null, "recent RAC version or instance affinity not enabled");
                float advisoryPercent = 0 == this.m_racMngr.rlbMetricsAccumulator.getReel().size() ? 100.0f / (float)this.getUpInstancesCount() : dbInstance.getAdvisoryPercent();
                ClioSupport.ilogFinest(null, null, null, null, String.format("advisoryPercent=%f, roomToGrowPool=%d", Float.valueOf(advisoryPercent), cbk.getRoomToGrowPool()));
                connNumThreshold = Math.round(advisoryPercent * (float)cbk.getMaxPoolSize() / 100.0f);
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "older RAC version and instance affinity enabled");
                connNumThreshold = cbk.getRoomToGrowPool() + dbInstance.getNumNamedInstanceConns();
            }
            ClioSupport.ilogFinest(null, null, null, null, String.format("dbVersion=%d, threshold=%d, connNum=%d", dbVersion, connNumThreshold, dbInstance.getNumberOfConnectionsCount()));
            return connNumThreshold > dbInstance.getNumberOfConnectionsCount();
        }
        ClioSupport.ilogFinest(null, null, null, null, "instance is not alive");
        return false;
    }

    public int size() {
        return this.instances.size();
    }

    public RACInstance getMostDesirableInstanceToGrow() {
        StringBuilder sb = new StringBuilder();
        sb.append("most desirable instance to grow: ");
        int maxConnsToGrow = Integer.MIN_VALUE;
        OracleDatabaseInstanceInfo instanceToGrow = this.lastUsedInstanceToGrow;
        for (Map.Entry<OracleDatabaseInstanceInfo, Integer> rlbPolicyEntry : this.rlbPolicy.getCurrentRebalancePolicy().entrySet()) {
            OracleDatabaseInstanceInfo dbInstance = rlbPolicyEntry.getKey();
            int rebalanceCount = rlbPolicyEntry.getValue();
            sb.append("(").append(dbInstance.getInstanceName()).append(":").append(rebalanceCount).append(")");
            OracleDatabaseInstanceInfo.RebalancingState state = dbInstance.getRebalancingState();
            if (OracleDatabaseInstanceInfo.RebalancingState.SHRINKING == state || OracleDatabaseInstanceInfo.RebalancingState.SHRUNK == state || rebalanceCount <= 0 || rebalanceCount <= maxConnsToGrow) continue;
            this.lastUsedInstanceToGrow = instanceToGrow = dbInstance;
            maxConnsToGrow = rebalanceCount;
        }
        if (null != instanceToGrow) {
            sb.append(" grow on ").append(instanceToGrow.getInstanceName());
            instanceToGrow.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.GROWING);
        } else {
            sb.append("no instance to grow");
        }
        ClioSupport.ilogFinest(null, null, null, null, sb.toString());
        return null == instanceToGrow ? null : new RACInstanceImpl(instanceToGrow);
    }

    public FailoverablePooledConnection selectConnectionPerRLBMetrics(ConnectionRetrievalInfo cri, RACManagerImpl racMngr) throws UniversalConnectionPoolException {
        FailoverablePooledConnection pc = this.rlbPolicy.borrowConnection(cri);
        if (pc != null) {
            racMngr.incrementSuccessfulRCLBBasedBorrowCount();
        } else {
            racMngr.incrementFailedRCLBBasedBorrowCount();
        }
        return pc;
    }

    public synchronized void scheduleInstancesForGravitation(BlockingQueue<OracleDatabaseInstanceInfo> instancesToGravitateQueue) {
        for (Map.Entry<OracleDatabaseInstanceInfo, Integer> rlbPolicyEntry : this.rlbPolicy.getCurrentRebalancePolicy().entrySet()) {
            OracleDatabaseInstanceInfo dbInstance = rlbPolicyEntry.getKey();
            int rebalanceCount = rlbPolicyEntry.getValue();
            OracleDatabaseInstanceInfo.RebalancingState state = dbInstance.getRebalancingState();
            if (OracleDatabaseInstanceInfo.RebalancingState.GROWING == state || rebalanceCount >= 0) continue;
            ClioSupport.ilogFinest(null, null, null, null, "gravitate " + dbInstance.getInstanceName() + ", " + rebalanceCount + " connections");
            dbInstance.setConnsToTearDown(Math.abs(rebalanceCount));
            dbInstance.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.SHRINKING);
            instancesToGravitateQueue.add(dbInstance);
        }
    }

    public boolean useGoodGroup() {
        float goodGroupPercent = 0.0f;
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (1 != dbInstance.status || 4 == dbInstance.flag || 5 == dbInstance.flag) continue;
            goodGroupPercent += dbInstance.getAdvisoryPercent();
        }
        return goodGroupPercent > 0.0f;
    }

    private FailoverablePooledConnection getConnectionToNamedInstance(OracleDatabaseInstanceInfo dbInstance, boolean forQueryInstanceId) {
        FailoverablePooledConnection fpc = null;
        String namedInstanceUrl = dbInstance.getNamedInstanceUrl();
        try {
            RACInstanceImpl racInstance = new RACInstanceImpl(dbInstance);
            fpc = this.m_racMngr.getRACCallback().openNewConnection(namedInstanceUrl, racInstance);
        }
        catch (Exception exc) {
            fpc = null;
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
        if (fpc != null) {
            fpc.setAsNamedInstanceConnection();
            if (!forQueryInstanceId) {
                dbInstance.incrementNumNamedInstanceConns();
            }
        }
        return fpc;
    }

    public void markUpInstanceForUpEvent(String upServiceName, String upInstanceName, String upHostName, String upDbName) {
        int upInstId;
        OracleDatabaseInstanceInfo upInstance = new OracleDatabaseInstanceInfo(upDbName, upInstanceName, upHostName);
        upInstance.setServiceName(upServiceName);
        Integer instNum = this.instances.getId(upInstance);
        int n = upInstId = instNum != null ? instNum : -1;
        if (upInstId != -1) {
            upInstance = this.instances.getInstance(upInstId);
            upInstance.status = 1;
        } else {
            this.setNamedInstanceUrl(upInstance, upInstance.getInstanceName());
            upInstance.status = 1;
            FailoverablePooledConnection namedInstanceConn = this.getConnectionToNamedInstance(upInstance, true);
            if (null != namedInstanceConn) {
                int newInstanceId = namedInstanceConn.getInstanceNumber();
                if (newInstanceId >= 0) {
                    this.instances.add(upInstance, newInstanceId);
                }
                try {
                    namedInstanceConn.close(false);
                }
                catch (UniversalConnectionPoolException exc) {
                    ClioSupport.ilogThrowing(null, null, null, null, exc);
                }
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "namedInstanceConn is null");
            }
        }
    }

    public void markDownInstanceForServiceDownEvent(String downInstanceName, String downDbName) {
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (downInstanceName == null) {
                dbInstance.status = 2;
                continue;
            }
            if (!Util.sameOrEqual(downDbName, dbInstance.getDatabaseName()) || !Util.sameOrEqual(downInstanceName, dbInstance.getInstanceName())) continue;
            dbInstance.status = 2;
        }
    }

    public void markDownInstanceForHostDownEvent(String downHostName) {
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (!Util.sameOrEqual(downHostName, dbInstance.getHostName())) continue;
            dbInstance.status = 2;
        }
    }

    public int getUpInstancesCount() {
        int upCount = 0;
        for (OracleDatabaseInstanceInfo dbInstance : this.instances.getAllInstances()) {
            if (dbInstance.status != 1) continue;
            ++upCount;
        }
        return upCount;
    }

    public OracleDatabaseInstanceInfo getOracleDatabaseInstanceInfo(String instanceName, String databaseName) {
        return this.instances.getInstance(databaseName, instanceName);
    }

    public OracleDatabaseInstanceInfo getOracleDatabaseInstanceInfo(int instanceId) {
        return this.instances.getInstance(instanceId);
    }

    public INSTANCE_CATEGORY_FOR_DATA_AFFINITY getInstanceCategory(OracleDatabaseInstanceInfo dbInstance) {
        String instanceKey = this.m_racMngr.generateDatabaseInstanceKey(dbInstance.getInstanceName(), dbInstance.getDatabaseName(), dbInstance.getServiceName());
        boolean affinityHint = this.m_racMngr.getConnectionAffinityValue(instanceKey);
        if (dbInstance.status == 1 && (dbInstance.flag == 1 || dbInstance.flag == 2) && affinityHint) {
            return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.GOOD_INSTANCE;
        }
        if (!(dbInstance.status != 1 || dbInstance.flag != 3 && affinityHint)) {
            return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.VIOLATING_INSTANCE;
        }
        return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.BAD_INSTANCE;
    }

    public Collection<OracleDatabaseInstanceInfo> getRacMetadata() {
        return this.instances.getAllInstances();
    }

    static {
        try {
            $$$methodRef$$$19 = OracleDatabaseInstanceInfoList.class.getDeclaredConstructor(RACManagerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("access$000", OracleDatabaseInstanceInfoList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getRacMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getInstanceCategory", OracleDatabaseInstanceInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getOracleDatabaseInstanceInfo", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getOracleDatabaseInstanceInfo", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getUpInstancesCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("markDownInstanceForHostDownEvent", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("markDownInstanceForServiceDownEvent", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("markUpInstanceForUpEvent", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getConnectionToNamedInstance", OracleDatabaseInstanceInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("useGoodGroup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("scheduleInstancesForGravitation", BlockingQueue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("selectConnectionPerRLBMetrics", ConnectionRetrievalInfo.class, RACManagerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getMostDesirableInstanceToGrow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("isNamedInstanceConnectingAllowed", String.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("setNamedInstanceUrl", OracleDatabaseInstanceInfo.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("updateDatabaseInstanceInfo", OracleDatabaseInstanceInfo.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getAllInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    public static final class INSTANCE_CATEGORY_FOR_DATA_AFFINITY
    extends Enum<INSTANCE_CATEGORY_FOR_DATA_AFFINITY> {
        public static final /* enum */ INSTANCE_CATEGORY_FOR_DATA_AFFINITY GOOD_INSTANCE;
        public static final /* enum */ INSTANCE_CATEGORY_FOR_DATA_AFFINITY VIOLATING_INSTANCE;
        public static final /* enum */ INSTANCE_CATEGORY_FOR_DATA_AFFINITY BAD_INSTANCE;
        private static final /* synthetic */ INSTANCE_CATEGORY_FOR_DATA_AFFINITY[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static INSTANCE_CATEGORY_FOR_DATA_AFFINITY[] values() {
            return (INSTANCE_CATEGORY_FOR_DATA_AFFINITY[])$VALUES.clone();
        }

        public static INSTANCE_CATEGORY_FOR_DATA_AFFINITY valueOf(String name) {
            return Enum.valueOf(INSTANCE_CATEGORY_FOR_DATA_AFFINITY.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = INSTANCE_CATEGORY_FOR_DATA_AFFINITY.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = INSTANCE_CATEGORY_FOR_DATA_AFFINITY.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = INSTANCE_CATEGORY_FOR_DATA_AFFINITY.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            GOOD_INSTANCE = new INSTANCE_CATEGORY_FOR_DATA_AFFINITY();
            VIOLATING_INSTANCE = new INSTANCE_CATEGORY_FOR_DATA_AFFINITY();
            BAD_INSTANCE = new INSTANCE_CATEGORY_FOR_DATA_AFFINITY();
            $VALUES = new INSTANCE_CATEGORY_FOR_DATA_AFFINITY[]{GOOD_INSTANCE, VIOLATING_INSTANCE, BAD_INSTANCE};
        }
    }

    public static class Instances {
        private static final String BROKEN = "instance info base integrity is broken";
        private Map<OracleDatabaseInstanceInfo, Integer> instanceToId = new HashMap<OracleDatabaseInstanceInfo, Integer>();
        private Map<Integer, OracleDatabaseInstanceInfo> idToInstance = new HashMap<Integer, OracleDatabaseInstanceInfo>();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        synchronized OracleDatabaseInstanceInfo getInstance(int id) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            assert (id >= 0) : "negative id";
            return this.idToInstance.get(id);
        }

        synchronized OracleDatabaseInstanceInfo getInstance(String databaseName, String instanceName) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return this.idToInstance.get(this.instanceToId.get(new OracleDatabaseInstanceInfo(databaseName, instanceName)));
        }

        synchronized Collection<OracleDatabaseInstanceInfo> getAllInstances() {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return new ArrayList<OracleDatabaseInstanceInfo>(this.idToInstance.values());
        }

        synchronized Integer getId(OracleDatabaseInstanceInfo instance) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return this.instanceToId.get(instance);
        }

        public synchronized void add(OracleDatabaseInstanceInfo instance, int id) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            assert (id >= 0) : "negative id";
            assert (null != instance) : "instance is null";
            Integer oldId = this.instanceToId.get(instance);
            OracleDatabaseInstanceInfo oldInstance = this.idToInstance.get(id);
            if (null != oldId && oldId.equals(id) && null != oldInstance && oldInstance.equals(instance)) {
                return;
            }
            assert (null == oldId && null == oldInstance) : "some other pair with either given instance or id has been previously written";
            this.instanceToId.put(instance, id);
            this.idToInstance.put(id, instance);
        }

        synchronized int size() {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return this.instanceToId.size();
        }

        static {
            try {
                $$$methodRef$$$6 = Instances.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = Instances.class.getDeclaredMethod("size", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = Instances.class.getDeclaredMethod("add", OracleDatabaseInstanceInfo.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = Instances.class.getDeclaredMethod("getId", OracleDatabaseInstanceInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = Instances.class.getDeclaredMethod("getAllInstances", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Instances.class.getDeclaredMethod("getInstance", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Instances.class.getDeclaredMethod("getInstance", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

