/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.FilterConfig;
import org.apache.catalina.util.RateLimiter;
import org.apache.catalina.util.TimeBucketCounter;
import org.apache.tomcat.util.threads.ScheduledThreadPoolExecutor;

public class FastRateLimiter
implements RateLimiter {
    private static AtomicInteger index = new AtomicInteger();
    TimeBucketCounter bucketCounter;
    int duration;
    int requests;
    int actualRequests;
    int actualDuration;
    private String policyName = "fast-" + index.incrementAndGet();

    @Override
    public String getPolicyName() {
        return this.policyName;
    }

    @Override
    public void setPolicyName(String name) {
        this.policyName = name;
    }

    @Override
    public int getDuration() {
        return this.actualDuration;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public int getRequests() {
        return this.actualRequests;
    }

    @Override
    public void setRequests(int requests) {
        this.requests = requests;
    }

    @Override
    public int increment(String ipAddress) {
        return this.bucketCounter.increment(ipAddress);
    }

    @Override
    public void destroy() {
        this.bucketCounter.destroy();
    }

    @Override
    public void setFilterConfig(FilterConfig filterConfig) {
        ScheduledExecutorService executorService = (ScheduledExecutorService)filterConfig.getServletContext().getAttribute(ScheduledThreadPoolExecutor.class.getName());
        if (executorService == null) {
            executorService = new java.util.concurrent.ScheduledThreadPoolExecutor(1);
        }
        this.bucketCounter = new TimeBucketCounter(this.duration, executorService);
        this.actualRequests = (int)Math.round(this.bucketCounter.getRatio() * (double)this.requests);
        this.actualDuration = this.bucketCounter.getActualDuration() / 1000;
    }

    public TimeBucketCounter getBucketCounter() {
        return this.bucketCounter;
    }
}

