/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.key;

import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.dialect.DialectRegistry;
import org.polyjdbc.core.key.AutoIncremented;
import org.polyjdbc.core.key.KeyGenerator;
import org.polyjdbc.core.key.SequenceAllocation;

public class KeyGeneratorFactory {
    public static KeyGenerator create(Dialect dialect) {
        switch (DialectRegistry.valueOf(dialect.getCode())) {
            case H2: {
                return new SequenceAllocation(dialect);
            }
            case POSTGRES: {
                return new SequenceAllocation(dialect);
            }
            case MYSQL: {
                return new AutoIncremented();
            }
            case ORACLE: {
                return new SequenceAllocation(dialect);
            }
            case MSSQL: {
                return new SequenceAllocation(dialect);
            }
            case DB2400: {
                return new SequenceAllocation(dialect);
            }
            case DB2: {
                return new SequenceAllocation(dialect);
            }
        }
        throw new IllegalStateException("Cannot create key generator for unknown dialect: " + dialect.getCode());
    }
}

