/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.query;

import org.polyjdbc.core.query.Query;
import org.polyjdbc.core.type.ColumnTypeMapper;
import org.polyjdbc.core.util.StringBuilderUtil;

public class UpdateQuery {
    private static final int VALUES_LENGTH = 50;
    private Query query;
    private StringBuilder values = new StringBuilder(50);
    private StringBuilder where = new StringBuilder(50);

    UpdateQuery(ColumnTypeMapper typeMapper, String what) {
        this.query = new Query(typeMapper);
        this.query.append("UPDATE ").append(what).append(" SET ");
    }

    Query build() {
        StringBuilderUtil.deleteLastCharacters(this.values, 2);
        this.query.append(this.values.toString()).append(" ").append(this.where.toString());
        this.query.compile();
        return this.query;
    }

    public UpdateQuery set(String fieldName, Object value) {
        String updatedFieldName = "update_" + fieldName;
        this.values.append(fieldName).append(" = :").append(updatedFieldName).append(", ");
        this.query.setArgument(updatedFieldName, value);
        return this;
    }

    public UpdateQuery where(String conditions) {
        this.where.append("WHERE ").append(conditions);
        return this;
    }

    public UpdateQuery withArgument(String argumentName, Object object) {
        this.query.setArgument(argumentName, object);
        return this;
    }
}

