package org.qubership.atp.environments.clients.api.catalogue.generated;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.clients.api.catalogue.generated.ActionParameterDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.MetaInfoDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.ScenarioTypeDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.UserInfoDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CompoundDto
 */

@JsonTypeName("Compound")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-02T09:52:47.142808168Z[Etc/UTC]")
public class CompoundDto {

  @JsonProperty("comment")
  private String comment;

  @JsonProperty("createdBy")
  private UserInfoDto createdBy;

  @JsonProperty("createdWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdWhen;

  @JsonProperty("deprecated")
  private Boolean deprecated;

  @JsonProperty("description")
  private String description;

  @JsonProperty("metainfo")
  @Valid
  private List<MetaInfoDto> metainfo = null;

  @JsonProperty("modifiedBy")
  private UserInfoDto modifiedBy;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  @JsonProperty("parameters")
  @Valid
  private List<ActionParameterDto> parameters = null;

  @JsonProperty("projectUuid")
  private UUID projectUuid;

  @JsonProperty("qaDslLibraryId")
  private UUID qaDslLibraryId;

  @JsonProperty("type")
  private ScenarioTypeDto type;

  @JsonProperty("uuid")
  private UUID uuid;

  public CompoundDto comment(String comment) {
    this.comment = comment;
    return this;
  }

  /**
   * Get comment
   * @return comment
  */
  
  @Schema(name = "comment", required = false)
  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public CompoundDto createdBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UserInfoDto getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
  }

  public CompoundDto createdWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
    return this;
  }

  /**
   * Get createdWhen
   * @return createdWhen
  */
  @Valid 
  @Schema(name = "createdWhen", required = false)
  public OffsetDateTime getCreatedWhen() {
    return createdWhen;
  }

  public void setCreatedWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
  }

  public CompoundDto deprecated(Boolean deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * Get deprecated
   * @return deprecated
  */
  
  @Schema(name = "deprecated", required = false)
  public Boolean getDeprecated() {
    return deprecated;
  }

  public void setDeprecated(Boolean deprecated) {
    this.deprecated = deprecated;
  }

  public CompoundDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public CompoundDto metainfo(List<MetaInfoDto> metainfo) {
    this.metainfo = metainfo;
    return this;
  }

  public CompoundDto addMetainfoItem(MetaInfoDto metainfoItem) {
    if (this.metainfo == null) {
      this.metainfo = new ArrayList<>();
    }
    this.metainfo.add(metainfoItem);
    return this;
  }

  /**
   * Get metainfo
   * @return metainfo
  */
  @Valid 
  @Schema(name = "metainfo", required = false)
  public List<MetaInfoDto> getMetainfo() {
    return metainfo;
  }

  public void setMetainfo(List<MetaInfoDto> metainfo) {
    this.metainfo = metainfo;
  }

  public CompoundDto modifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UserInfoDto getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public CompoundDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public CompoundDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CompoundDto parameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }

  public CompoundDto addParametersItem(ActionParameterDto parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  @Valid 
  @Schema(name = "parameters", required = false)
  public List<ActionParameterDto> getParameters() {
    return parameters;
  }

  public void setParameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
  }

  public CompoundDto projectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
    return this;
  }

  /**
   * Get projectUuid
   * @return projectUuid
  */
  @Valid 
  @Schema(name = "projectUuid", required = false)
  public UUID getProjectUuid() {
    return projectUuid;
  }

  public void setProjectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
  }

  public CompoundDto qaDslLibraryId(UUID qaDslLibraryId) {
    this.qaDslLibraryId = qaDslLibraryId;
    return this;
  }

  /**
   * Get qaDslLibraryId
   * @return qaDslLibraryId
  */
  @Valid 
  @Schema(name = "qaDslLibraryId", required = false)
  public UUID getQaDslLibraryId() {
    return qaDslLibraryId;
  }

  public void setQaDslLibraryId(UUID qaDslLibraryId) {
    this.qaDslLibraryId = qaDslLibraryId;
  }

  public CompoundDto type(ScenarioTypeDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", required = false)
  public ScenarioTypeDto getType() {
    return type;
  }

  public void setType(ScenarioTypeDto type) {
    this.type = type;
  }

  public CompoundDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompoundDto compound = (CompoundDto) o;
    return Objects.equals(this.comment, compound.comment) &&
        Objects.equals(this.createdBy, compound.createdBy) &&
        Objects.equals(this.createdWhen, compound.createdWhen) &&
        Objects.equals(this.deprecated, compound.deprecated) &&
        Objects.equals(this.description, compound.description) &&
        Objects.equals(this.metainfo, compound.metainfo) &&
        Objects.equals(this.modifiedBy, compound.modifiedBy) &&
        Objects.equals(this.modifiedWhen, compound.modifiedWhen) &&
        Objects.equals(this.name, compound.name) &&
        Objects.equals(this.parameters, compound.parameters) &&
        Objects.equals(this.projectUuid, compound.projectUuid) &&
        Objects.equals(this.qaDslLibraryId, compound.qaDslLibraryId) &&
        Objects.equals(this.type, compound.type) &&
        Objects.equals(this.uuid, compound.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(comment, createdBy, createdWhen, deprecated, description, metainfo, modifiedBy, modifiedWhen, name, parameters, projectUuid, qaDslLibraryId, type, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompoundDto {\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdWhen: ").append(toIndentedString(createdWhen)).append("\n");
    sb.append("    deprecated: ").append(toIndentedString(deprecated)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    metainfo: ").append(toIndentedString(metainfo)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    projectUuid: ").append(toIndentedString(projectUuid)).append("\n");
    sb.append("    qaDslLibraryId: ").append(toIndentedString(qaDslLibraryId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

