package org.qubership.atp.environments.clients.api.catalogue.generated;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.clients.api.catalogue.generated.JiraComponentDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.PriorityDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestCaseDependencyDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestCaseFlagsDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestCaseOrderDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestCaseRepeatCountDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.TestCaseStatusDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.UserInfoDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestCaseDto
 */

@JsonTypeName("TestCase")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-02T09:52:47.142808168Z[Etc/UTC]")
public class TestCaseDto {

  @JsonProperty("assignee")
  private UserInfoDto assignee;

  @JsonProperty("components")
  @Valid
  private List<JiraComponentDto> components = null;

  @JsonProperty("createdBy")
  private UserInfoDto createdBy;

  @JsonProperty("createdWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdWhen;

  @JsonProperty("datasetStorageUuid")
  private UUID datasetStorageUuid;

  @JsonProperty("datasetUuid")
  private UUID datasetUuid;

  @JsonProperty("dependsOn")
  @Valid
  private List<TestCaseDependencyDto> dependsOn = null;

  @JsonProperty("description")
  private String description;

  @JsonProperty("flags")
  @Valid
  private List<TestCaseFlagsDto> flags = null;

  @JsonProperty("groupId")
  private UUID groupId;

  @JsonProperty("jiraTicket")
  private String jiraTicket;

  @JsonProperty("labelIds")
  @Valid
  private List<UUID> labelIds = null;

  @JsonProperty("lastRun")
  private UUID lastRun;

  @JsonProperty("lastRunStatus")
  private String lastRunStatus;

  @JsonProperty("modifiedBy")
  private UserInfoDto modifiedBy;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  @JsonProperty("order")
  @Valid
  private List<TestCaseOrderDto> order = null;

  @JsonProperty("priority")
  private PriorityDto priority;

  @JsonProperty("projectUuid")
  private UUID projectUuid;

  @JsonProperty("status")
  private TestCaseStatusDto status;

  @JsonProperty("testCaseRepeatCounts")
  @Valid
  private List<TestCaseRepeatCountDto> testCaseRepeatCounts = null;

  @JsonProperty("testPlanUuid")
  private UUID testPlanUuid;

  @JsonProperty("testScenarioUuid")
  private UUID testScenarioUuid;

  @JsonProperty("uuid")
  private UUID uuid;

  public TestCaseDto assignee(UserInfoDto assignee) {
    this.assignee = assignee;
    return this;
  }

  /**
   * Get assignee
   * @return assignee
  */
  @Valid 
  @Schema(name = "assignee", required = false)
  public UserInfoDto getAssignee() {
    return assignee;
  }

  public void setAssignee(UserInfoDto assignee) {
    this.assignee = assignee;
  }

  public TestCaseDto components(List<JiraComponentDto> components) {
    this.components = components;
    return this;
  }

  public TestCaseDto addComponentsItem(JiraComponentDto componentsItem) {
    if (this.components == null) {
      this.components = new ArrayList<>();
    }
    this.components.add(componentsItem);
    return this;
  }

  /**
   * Get components
   * @return components
  */
  @Valid 
  @Schema(name = "components", required = false)
  public List<JiraComponentDto> getComponents() {
    return components;
  }

  public void setComponents(List<JiraComponentDto> components) {
    this.components = components;
  }

  public TestCaseDto createdBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UserInfoDto getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
  }

  public TestCaseDto createdWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
    return this;
  }

  /**
   * Get createdWhen
   * @return createdWhen
  */
  @Valid 
  @Schema(name = "createdWhen", required = false)
  public OffsetDateTime getCreatedWhen() {
    return createdWhen;
  }

  public void setCreatedWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
  }

  public TestCaseDto datasetStorageUuid(UUID datasetStorageUuid) {
    this.datasetStorageUuid = datasetStorageUuid;
    return this;
  }

  /**
   * Get datasetStorageUuid
   * @return datasetStorageUuid
  */
  @Valid 
  @Schema(name = "datasetStorageUuid", required = false)
  public UUID getDatasetStorageUuid() {
    return datasetStorageUuid;
  }

  public void setDatasetStorageUuid(UUID datasetStorageUuid) {
    this.datasetStorageUuid = datasetStorageUuid;
  }

  public TestCaseDto datasetUuid(UUID datasetUuid) {
    this.datasetUuid = datasetUuid;
    return this;
  }

  /**
   * Get datasetUuid
   * @return datasetUuid
  */
  @Valid 
  @Schema(name = "datasetUuid", required = false)
  public UUID getDatasetUuid() {
    return datasetUuid;
  }

  public void setDatasetUuid(UUID datasetUuid) {
    this.datasetUuid = datasetUuid;
  }

  public TestCaseDto dependsOn(List<TestCaseDependencyDto> dependsOn) {
    this.dependsOn = dependsOn;
    return this;
  }

  public TestCaseDto addDependsOnItem(TestCaseDependencyDto dependsOnItem) {
    if (this.dependsOn == null) {
      this.dependsOn = new ArrayList<>();
    }
    this.dependsOn.add(dependsOnItem);
    return this;
  }

  /**
   * Get dependsOn
   * @return dependsOn
  */
  @Valid 
  @Schema(name = "dependsOn", required = false)
  public List<TestCaseDependencyDto> getDependsOn() {
    return dependsOn;
  }

  public void setDependsOn(List<TestCaseDependencyDto> dependsOn) {
    this.dependsOn = dependsOn;
  }

  public TestCaseDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TestCaseDto flags(List<TestCaseFlagsDto> flags) {
    this.flags = flags;
    return this;
  }

  public TestCaseDto addFlagsItem(TestCaseFlagsDto flagsItem) {
    if (this.flags == null) {
      this.flags = new ArrayList<>();
    }
    this.flags.add(flagsItem);
    return this;
  }

  /**
   * Get flags
   * @return flags
  */
  @Valid 
  @Schema(name = "flags", required = false)
  public List<TestCaseFlagsDto> getFlags() {
    return flags;
  }

  public void setFlags(List<TestCaseFlagsDto> flags) {
    this.flags = flags;
  }

  public TestCaseDto groupId(UUID groupId) {
    this.groupId = groupId;
    return this;
  }

  /**
   * Get groupId
   * @return groupId
  */
  @Valid 
  @Schema(name = "groupId", required = false)
  public UUID getGroupId() {
    return groupId;
  }

  public void setGroupId(UUID groupId) {
    this.groupId = groupId;
  }

  public TestCaseDto jiraTicket(String jiraTicket) {
    this.jiraTicket = jiraTicket;
    return this;
  }

  /**
   * Get jiraTicket
   * @return jiraTicket
  */
  
  @Schema(name = "jiraTicket", required = false)
  public String getJiraTicket() {
    return jiraTicket;
  }

  public void setJiraTicket(String jiraTicket) {
    this.jiraTicket = jiraTicket;
  }

  public TestCaseDto labelIds(List<UUID> labelIds) {
    this.labelIds = labelIds;
    return this;
  }

  public TestCaseDto addLabelIdsItem(UUID labelIdsItem) {
    if (this.labelIds == null) {
      this.labelIds = new ArrayList<>();
    }
    this.labelIds.add(labelIdsItem);
    return this;
  }

  /**
   * Get labelIds
   * @return labelIds
  */
  @Valid 
  @Schema(name = "labelIds", required = false)
  public List<UUID> getLabelIds() {
    return labelIds;
  }

  public void setLabelIds(List<UUID> labelIds) {
    this.labelIds = labelIds;
  }

  public TestCaseDto lastRun(UUID lastRun) {
    this.lastRun = lastRun;
    return this;
  }

  /**
   * Get lastRun
   * @return lastRun
  */
  @Valid 
  @Schema(name = "lastRun", required = false)
  public UUID getLastRun() {
    return lastRun;
  }

  public void setLastRun(UUID lastRun) {
    this.lastRun = lastRun;
  }

  public TestCaseDto lastRunStatus(String lastRunStatus) {
    this.lastRunStatus = lastRunStatus;
    return this;
  }

  /**
   * Get lastRunStatus
   * @return lastRunStatus
  */
  
  @Schema(name = "lastRunStatus", required = false)
  public String getLastRunStatus() {
    return lastRunStatus;
  }

  public void setLastRunStatus(String lastRunStatus) {
    this.lastRunStatus = lastRunStatus;
  }

  public TestCaseDto modifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UserInfoDto getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public TestCaseDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public TestCaseDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestCaseDto order(List<TestCaseOrderDto> order) {
    this.order = order;
    return this;
  }

  public TestCaseDto addOrderItem(TestCaseOrderDto orderItem) {
    if (this.order == null) {
      this.order = new ArrayList<>();
    }
    this.order.add(orderItem);
    return this;
  }

  /**
   * Get order
   * @return order
  */
  @Valid 
  @Schema(name = "order", required = false)
  public List<TestCaseOrderDto> getOrder() {
    return order;
  }

  public void setOrder(List<TestCaseOrderDto> order) {
    this.order = order;
  }

  public TestCaseDto priority(PriorityDto priority) {
    this.priority = priority;
    return this;
  }

  /**
   * Get priority
   * @return priority
  */
  @Valid 
  @Schema(name = "priority", required = false)
  public PriorityDto getPriority() {
    return priority;
  }

  public void setPriority(PriorityDto priority) {
    this.priority = priority;
  }

  public TestCaseDto projectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
    return this;
  }

  /**
   * Get projectUuid
   * @return projectUuid
  */
  @Valid 
  @Schema(name = "projectUuid", required = false)
  public UUID getProjectUuid() {
    return projectUuid;
  }

  public void setProjectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
  }

  public TestCaseDto status(TestCaseStatusDto status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  @Valid 
  @Schema(name = "status", required = false)
  public TestCaseStatusDto getStatus() {
    return status;
  }

  public void setStatus(TestCaseStatusDto status) {
    this.status = status;
  }

  public TestCaseDto testCaseRepeatCounts(List<TestCaseRepeatCountDto> testCaseRepeatCounts) {
    this.testCaseRepeatCounts = testCaseRepeatCounts;
    return this;
  }

  public TestCaseDto addTestCaseRepeatCountsItem(TestCaseRepeatCountDto testCaseRepeatCountsItem) {
    if (this.testCaseRepeatCounts == null) {
      this.testCaseRepeatCounts = new ArrayList<>();
    }
    this.testCaseRepeatCounts.add(testCaseRepeatCountsItem);
    return this;
  }

  /**
   * Get testCaseRepeatCounts
   * @return testCaseRepeatCounts
  */
  @Valid 
  @Schema(name = "testCaseRepeatCounts", required = false)
  public List<TestCaseRepeatCountDto> getTestCaseRepeatCounts() {
    return testCaseRepeatCounts;
  }

  public void setTestCaseRepeatCounts(List<TestCaseRepeatCountDto> testCaseRepeatCounts) {
    this.testCaseRepeatCounts = testCaseRepeatCounts;
  }

  public TestCaseDto testPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
    return this;
  }

  /**
   * Get testPlanUuid
   * @return testPlanUuid
  */
  @Valid 
  @Schema(name = "testPlanUuid", required = false)
  public UUID getTestPlanUuid() {
    return testPlanUuid;
  }

  public void setTestPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
  }

  public TestCaseDto testScenarioUuid(UUID testScenarioUuid) {
    this.testScenarioUuid = testScenarioUuid;
    return this;
  }

  /**
   * Get testScenarioUuid
   * @return testScenarioUuid
  */
  @Valid 
  @Schema(name = "testScenarioUuid", required = false)
  public UUID getTestScenarioUuid() {
    return testScenarioUuid;
  }

  public void setTestScenarioUuid(UUID testScenarioUuid) {
    this.testScenarioUuid = testScenarioUuid;
  }

  public TestCaseDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCaseDto testCase = (TestCaseDto) o;
    return Objects.equals(this.assignee, testCase.assignee) &&
        Objects.equals(this.components, testCase.components) &&
        Objects.equals(this.createdBy, testCase.createdBy) &&
        Objects.equals(this.createdWhen, testCase.createdWhen) &&
        Objects.equals(this.datasetStorageUuid, testCase.datasetStorageUuid) &&
        Objects.equals(this.datasetUuid, testCase.datasetUuid) &&
        Objects.equals(this.dependsOn, testCase.dependsOn) &&
        Objects.equals(this.description, testCase.description) &&
        Objects.equals(this.flags, testCase.flags) &&
        Objects.equals(this.groupId, testCase.groupId) &&
        Objects.equals(this.jiraTicket, testCase.jiraTicket) &&
        Objects.equals(this.labelIds, testCase.labelIds) &&
        Objects.equals(this.lastRun, testCase.lastRun) &&
        Objects.equals(this.lastRunStatus, testCase.lastRunStatus) &&
        Objects.equals(this.modifiedBy, testCase.modifiedBy) &&
        Objects.equals(this.modifiedWhen, testCase.modifiedWhen) &&
        Objects.equals(this.name, testCase.name) &&
        Objects.equals(this.order, testCase.order) &&
        Objects.equals(this.priority, testCase.priority) &&
        Objects.equals(this.projectUuid, testCase.projectUuid) &&
        Objects.equals(this.status, testCase.status) &&
        Objects.equals(this.testCaseRepeatCounts, testCase.testCaseRepeatCounts) &&
        Objects.equals(this.testPlanUuid, testCase.testPlanUuid) &&
        Objects.equals(this.testScenarioUuid, testCase.testScenarioUuid) &&
        Objects.equals(this.uuid, testCase.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assignee, components, createdBy, createdWhen, datasetStorageUuid, datasetUuid, dependsOn, description, flags, groupId, jiraTicket, labelIds, lastRun, lastRunStatus, modifiedBy, modifiedWhen, name, order, priority, projectUuid, status, testCaseRepeatCounts, testPlanUuid, testScenarioUuid, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCaseDto {\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    components: ").append(toIndentedString(components)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdWhen: ").append(toIndentedString(createdWhen)).append("\n");
    sb.append("    datasetStorageUuid: ").append(toIndentedString(datasetStorageUuid)).append("\n");
    sb.append("    datasetUuid: ").append(toIndentedString(datasetUuid)).append("\n");
    sb.append("    dependsOn: ").append(toIndentedString(dependsOn)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    flags: ").append(toIndentedString(flags)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    jiraTicket: ").append(toIndentedString(jiraTicket)).append("\n");
    sb.append("    labelIds: ").append(toIndentedString(labelIds)).append("\n");
    sb.append("    lastRun: ").append(toIndentedString(lastRun)).append("\n");
    sb.append("    lastRunStatus: ").append(toIndentedString(lastRunStatus)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    projectUuid: ").append(toIndentedString(projectUuid)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    testCaseRepeatCounts: ").append(toIndentedString(testCaseRepeatCounts)).append("\n");
    sb.append("    testPlanUuid: ").append(toIndentedString(testPlanUuid)).append("\n");
    sb.append("    testScenarioUuid: ").append(toIndentedString(testScenarioUuid)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

