/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.environments.clients.api.healthcheck;

import org.qubership.atp.environments.clients.api.healthcheck.dto.EnvironmentStatusDto;
import org.qubership.atp.environments.clients.api.healthcheck.dto.MandatoryStatusesResponseDto;
import org.qubership.atp.environments.clients.api.healthcheck.dto.SystemStatusDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-02T09:52:47.021408362Z[Etc/UTC]")
@Validated
@Tag(name = "StatusController", description = "Status Controller")
public interface StatusControllerApi {

    /**
     * GET /rest/status/{projectId}/{environmentId} : checkEnvironment
     *
     * @param projectId projectId (required)
     * @param environmentId environmentId (required)
     * @param status status (optional)
     * @param _configuration configuration (optional)
     * @param onlyMandatory status (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "checkEnvironment",
        summary = "checkEnvironment",
        tags = { "status-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentStatusDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/status/{projectId}/{environmentId}",
        produces = { "application/json" }
    )
    ResponseEntity<EnvironmentStatusDto> checkEnvironment(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") String projectId,
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") String environmentId,
        @Parameter(name = "status", description = "status") @Valid @RequestParam(value = "status", required = false) Boolean status,
        @Parameter(name = "configuration", description = "configuration") @Valid @RequestParam(value = "configuration", required = false) Boolean _configuration,
        @Parameter(name = "onlyMandatory", description = "status") @Valid @RequestParam(value = "onlyMandatory", required = false) Boolean onlyMandatory
    );


    /**
     * GET /rest/status/byNames/{projectName}/{environmentName} : checkEnvironmentByNames
     *
     * @param projectName projectName (required)
     * @param environmentName environmentName (required)
     * @param status status (optional)
     * @param _configuration configuration (optional)
     * @param onlyMandatory status (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "checkEnvironmentByNames",
        summary = "checkEnvironmentByNames",
        tags = { "status-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentStatusDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/status/byNames/{projectName}/{environmentName}",
        produces = { "application/json" }
    )
    ResponseEntity<EnvironmentStatusDto> checkEnvironmentByNames(
        @Parameter(name = "projectName", description = "projectName", required = true) @PathVariable("projectName") String projectName,
        @Parameter(name = "environmentName", description = "environmentName", required = true) @PathVariable("environmentName") String environmentName,
        @Parameter(name = "status", description = "status") @Valid @RequestParam(value = "status", required = false) Boolean status,
        @Parameter(name = "configuration", description = "configuration") @Valid @RequestParam(value = "configuration", required = false) Boolean _configuration,
        @Parameter(name = "onlyMandatory", description = "status") @Valid @RequestParam(value = "onlyMandatory", required = false) Boolean onlyMandatory
    );


    /**
     * GET /rest/status/byNames/sentTo/{subscribers}/{projectName}/{environmentName} : checkEnvironmentByNamesAndSendNotifications
     *
     * @param projectName projectName (required)
     * @param environmentName environmentName (required)
     * @param subscribers subscribers (required)
     * @param reportSubject reportSubject (optional)
     * @param fail fail (optional)
     * @param warn warn (optional)
     * @param pass pass (optional)
     * @param status status (optional)
     * @param _configuration configuration (optional)
     * @param onlyMandatory status (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "checkEnvironmentByNamesAndSendNotifications",
        summary = "checkEnvironmentByNamesAndSendNotifications",
        tags = { "status-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentStatusDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/status/byNames/sentTo/{subscribers}/{projectName}/{environmentName}",
        produces = { "application/json" }
    )
    ResponseEntity<EnvironmentStatusDto> checkEnvironmentByNamesAndSendNotifications(
        @Parameter(name = "projectName", description = "projectName", required = true) @PathVariable("projectName") String projectName,
        @Parameter(name = "environmentName", description = "environmentName", required = true) @PathVariable("environmentName") String environmentName,
        @Parameter(name = "subscribers", description = "subscribers", required = true) @PathVariable("subscribers") String subscribers,
        @Parameter(name = "reportSubject", description = "reportSubject") @Valid @RequestParam(value = "reportSubject", required = false) String reportSubject,
        @Parameter(name = "fail", description = "fail") @Valid @RequestParam(value = "fail", required = false) Boolean fail,
        @Parameter(name = "warn", description = "warn") @Valid @RequestParam(value = "warn", required = false) Boolean warn,
        @Parameter(name = "pass", description = "pass") @Valid @RequestParam(value = "pass", required = false) Boolean pass,
        @Parameter(name = "status", description = "status") @Valid @RequestParam(value = "status", required = false) Boolean status,
        @Parameter(name = "configuration", description = "configuration") @Valid @RequestParam(value = "configuration", required = false) Boolean _configuration,
        @Parameter(name = "onlyMandatory", description = "status") @Valid @RequestParam(value = "onlyMandatory", required = false) Boolean onlyMandatory
    );


    /**
     * GET /rest/status/{projectId}/{environmentId}/{systemIds} : checkEnvironmentWithSpecifiedSystems
     *
     * @param projectId projectId (required)
     * @param environmentId environmentId (required)
     * @param systemIds systemIds (required)
     * @param status status (optional)
     * @param _configuration configuration (optional)
     * @param onlyMandatory status (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "checkEnvironmentWithSpecifiedSystems",
        summary = "checkEnvironmentWithSpecifiedSystems",
        tags = { "status-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentStatusDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/status/{projectId}/{environmentId}/{systemIds}",
        produces = { "application/json" }
    )
    ResponseEntity<EnvironmentStatusDto> checkEnvironmentWithSpecifiedSystems(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") String projectId,
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") String environmentId,
        @Parameter(name = "systemIds", description = "systemIds", required = true) @PathVariable("systemIds") String systemIds,
        @Parameter(name = "status", description = "status") @Valid @RequestParam(value = "status", required = false) Boolean status,
        @Parameter(name = "configuration", description = "configuration") @Valid @RequestParam(value = "configuration", required = false) Boolean _configuration,
        @Parameter(name = "onlyMandatory", description = "status") @Valid @RequestParam(value = "onlyMandatory", required = false) Boolean onlyMandatory
    );


    /**
     * GET /rest/status/byNames/{projectName}/{environmentName}/{systemNames} : checkEnvironmentWithSpecifiedSystemsByNames
     *
     * @param projectName projectName (required)
     * @param environmentName environmentName (required)
     * @param systemNames systemNames (required)
     * @param status status (optional)
     * @param _configuration configuration (optional)
     * @param onlyMandatory status (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "checkEnvironmentWithSpecifiedSystemsByNames",
        summary = "checkEnvironmentWithSpecifiedSystemsByNames",
        tags = { "status-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentStatusDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/status/byNames/{projectName}/{environmentName}/{systemNames}",
        produces = { "application/json" }
    )
    ResponseEntity<EnvironmentStatusDto> checkEnvironmentWithSpecifiedSystemsByNames(
        @Parameter(name = "projectName", description = "projectName", required = true) @PathVariable("projectName") String projectName,
        @Parameter(name = "environmentName", description = "environmentName", required = true) @PathVariable("environmentName") String environmentName,
        @Parameter(name = "systemNames", description = "systemNames", required = true) @PathVariable("systemNames") String systemNames,
        @Parameter(name = "status", description = "status") @Valid @RequestParam(value = "status", required = false) Boolean status,
        @Parameter(name = "configuration", description = "configuration") @Valid @RequestParam(value = "configuration", required = false) Boolean _configuration,
        @Parameter(name = "onlyMandatory", description = "status") @Valid @RequestParam(value = "onlyMandatory", required = false) Boolean onlyMandatory
    );


    /**
     * GET /rest/status/byNames/sentTo/{subscribers}/{projectName}/{environmentName}/{systemNames} : checkEnvironmentWithSpecifiedSystemsByNamesAndSendNotifications
     *
     * @param projectName projectName (required)
     * @param environmentName environmentName (required)
     * @param systemNames systemNames (required)
     * @param subscribers subscribers (required)
     * @param reportSubject reportSubject (optional)
     * @param fail fail (optional)
     * @param warn warn (optional)
     * @param pass pass (optional)
     * @param status status (optional)
     * @param _configuration configuration (optional)
     * @param onlyMandatory status (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "checkEnvironmentWithSpecifiedSystemsByNamesAndSendNotifications",
        summary = "checkEnvironmentWithSpecifiedSystemsByNamesAndSendNotifications",
        tags = { "status-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentStatusDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/status/byNames/sentTo/{subscribers}/{projectName}/{environmentName}/{systemNames}",
        produces = { "application/json" }
    )
    ResponseEntity<EnvironmentStatusDto> checkEnvironmentWithSpecifiedSystemsByNamesAndSendNotifications(
        @Parameter(name = "projectName", description = "projectName", required = true) @PathVariable("projectName") String projectName,
        @Parameter(name = "environmentName", description = "environmentName", required = true) @PathVariable("environmentName") String environmentName,
        @Parameter(name = "systemNames", description = "systemNames", required = true) @PathVariable("systemNames") String systemNames,
        @Parameter(name = "subscribers", description = "subscribers", required = true) @PathVariable("subscribers") String subscribers,
        @Parameter(name = "reportSubject", description = "reportSubject") @Valid @RequestParam(value = "reportSubject", required = false) String reportSubject,
        @Parameter(name = "fail", description = "fail") @Valid @RequestParam(value = "fail", required = false) Boolean fail,
        @Parameter(name = "warn", description = "warn") @Valid @RequestParam(value = "warn", required = false) Boolean warn,
        @Parameter(name = "pass", description = "pass") @Valid @RequestParam(value = "pass", required = false) Boolean pass,
        @Parameter(name = "status", description = "status") @Valid @RequestParam(value = "status", required = false) Boolean status,
        @Parameter(name = "configuration", description = "configuration") @Valid @RequestParam(value = "configuration", required = false) Boolean _configuration,
        @Parameter(name = "onlyMandatory", description = "status") @Valid @RequestParam(value = "onlyMandatory", required = false) Boolean onlyMandatory
    );


    /**
     * GET /rest/status/timezones/{projectId} : checkProject
     *
     * @param projectId projectId (required)
     * @param status status (optional)
     * @param _configuration configuration (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "checkProject",
        summary = "checkProject",
        tags = { "status-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentStatusDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/status/timezones/{projectId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentStatusDto>> checkProject(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") String projectId,
        @Parameter(name = "status", description = "status") @Valid @RequestParam(value = "status", required = false) Boolean status,
        @Parameter(name = "configuration", description = "configuration") @Valid @RequestParam(value = "configuration", required = false) Boolean _configuration
    );


    /**
     * GET /rest/status/system/{projectId}/{environmentId}/{systemId} : checkSystem
     *
     * @param projectId projectId (required)
     * @param environmentId environmentId (required)
     * @param systemId systemId (required)
     * @param status status (optional)
     * @param _configuration configuration (optional)
     * @param onlyMandatory status (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "checkSystem",
        summary = "checkSystem",
        tags = { "status-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemStatusDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/status/system/{projectId}/{environmentId}/{systemId}",
        produces = { "application/json" }
    )
    ResponseEntity<SystemStatusDto> checkSystem(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") String projectId,
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") String environmentId,
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") String systemId,
        @Parameter(name = "status", description = "status") @Valid @RequestParam(value = "status", required = false) Boolean status,
        @Parameter(name = "configuration", description = "configuration") @Valid @RequestParam(value = "configuration", required = false) Boolean _configuration,
        @Parameter(name = "onlyMandatory", description = "status") @Valid @RequestParam(value = "onlyMandatory", required = false) Boolean onlyMandatory
    );


    /**
     * GET /rest/status/report/{projectId}/{environmentIds}/{executionRequestId} : mandatoryCheckEnvironments
     *
     * @param projectId projectId (required)
     * @param environmentIds environmentIds (required)
     * @param executionRequestId executionRequestId (required)
     * @param status status (optional)
     * @param _configuration configuration (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "mandatoryCheckEnvironments",
        summary = "mandatoryCheckEnvironments",
        tags = { "status-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = MandatoryStatusesResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/status/report/{projectId}/{environmentIds}/{executionRequestId}",
        produces = { "application/json" }
    )
    ResponseEntity<MandatoryStatusesResponseDto> mandatoryCheckEnvironments(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "environmentIds", description = "environmentIds", required = true) @PathVariable("environmentIds") List<UUID> environmentIds,
        @Parameter(name = "executionRequestId", description = "executionRequestId", required = true) @PathVariable("executionRequestId") UUID executionRequestId,
        @Parameter(name = "status", description = "status") @Valid @RequestParam(value = "status", required = false) Boolean status,
        @Parameter(name = "configuration", description = "configuration") @Valid @RequestParam(value = "configuration", required = false) Boolean _configuration
    );

}
