package org.qubership.atp.environments.clients.api.healthcheck.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.environments.clients.api.healthcheck.dto.StatusDto;
import org.qubership.atp.environments.clients.api.healthcheck.dto.SystemStatusDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * EnvironmentStatusDto
 */

@JsonTypeName("EnvironmentStatus")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-02T09:52:47.021408362Z[Etc/UTC]")
public class EnvironmentStatusDto {

  @JsonProperty("id")
  private String id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("systemStatuses")
  @Valid
  private List<SystemStatusDto> systemStatuses = null;

  @JsonProperty("status")
  private StatusDto status;

  @JsonProperty("startCheckDate")
  private String startCheckDate;

  @JsonProperty("endCheckDate")
  private String endCheckDate;

  public EnvironmentStatusDto id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  
  @Schema(name = "id", required = false)
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public EnvironmentStatusDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public EnvironmentStatusDto systemStatuses(List<SystemStatusDto> systemStatuses) {
    this.systemStatuses = systemStatuses;
    return this;
  }

  public EnvironmentStatusDto addSystemStatusesItem(SystemStatusDto systemStatusesItem) {
    if (this.systemStatuses == null) {
      this.systemStatuses = new ArrayList<>();
    }
    this.systemStatuses.add(systemStatusesItem);
    return this;
  }

  /**
   * Get systemStatuses
   * @return systemStatuses
  */
  @Valid 
  @Schema(name = "systemStatuses", required = false)
  public List<SystemStatusDto> getSystemStatuses() {
    return systemStatuses;
  }

  public void setSystemStatuses(List<SystemStatusDto> systemStatuses) {
    this.systemStatuses = systemStatuses;
  }

  public EnvironmentStatusDto status(StatusDto status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  @Valid 
  @Schema(name = "status", required = false)
  public StatusDto getStatus() {
    return status;
  }

  public void setStatus(StatusDto status) {
    this.status = status;
  }

  public EnvironmentStatusDto startCheckDate(String startCheckDate) {
    this.startCheckDate = startCheckDate;
    return this;
  }

  /**
   * Get startCheckDate
   * @return startCheckDate
  */
  
  @Schema(name = "startCheckDate", required = false)
  public String getStartCheckDate() {
    return startCheckDate;
  }

  public void setStartCheckDate(String startCheckDate) {
    this.startCheckDate = startCheckDate;
  }

  public EnvironmentStatusDto endCheckDate(String endCheckDate) {
    this.endCheckDate = endCheckDate;
    return this;
  }

  /**
   * Get endCheckDate
   * @return endCheckDate
  */
  
  @Schema(name = "endCheckDate", required = false)
  public String getEndCheckDate() {
    return endCheckDate;
  }

  public void setEndCheckDate(String endCheckDate) {
    this.endCheckDate = endCheckDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EnvironmentStatusDto environmentStatus = (EnvironmentStatusDto) o;
    return Objects.equals(this.id, environmentStatus.id) &&
        Objects.equals(this.name, environmentStatus.name) &&
        Objects.equals(this.systemStatuses, environmentStatus.systemStatuses) &&
        Objects.equals(this.status, environmentStatus.status) &&
        Objects.equals(this.startCheckDate, environmentStatus.startCheckDate) &&
        Objects.equals(this.endCheckDate, environmentStatus.endCheckDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, systemStatuses, status, startCheckDate, endCheckDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EnvironmentStatusDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    systemStatuses: ").append(toIndentedString(systemStatuses)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    startCheckDate: ").append(toIndentedString(startCheckDate)).append("\n");
    sb.append("    endCheckDate: ").append(toIndentedString(endCheckDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

