package org.qubership.atp.environments.clients.api.healthcheck.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.environments.clients.api.healthcheck.dto.AttachmentDto;
import org.qubership.atp.environments.clients.api.healthcheck.dto.StatusDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProcessStatusDto
 */

@JsonTypeName("ProcessStatus")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-02T09:52:47.021408362Z[Etc/UTC]")
public class ProcessStatusDto {

  @JsonProperty("process")
  private String process;

  @JsonProperty("actual")
  private String actual;

  @JsonProperty("expected")
  private String expected;

  @JsonProperty("status")
  private StatusDto status;

  @JsonProperty("isHtml")
  private Boolean isHtml;

  @JsonProperty("notAffectStatus")
  private Boolean notAffectStatus;

  @JsonProperty("attachments")
  @Valid
  private List<AttachmentDto> attachments = null;

  @JsonProperty("isMandatory")
  private Boolean isMandatory;

  public ProcessStatusDto process(String process) {
    this.process = process;
    return this;
  }

  /**
   * Get process
   * @return process
  */
  
  @Schema(name = "process", required = false)
  public String getProcess() {
    return process;
  }

  public void setProcess(String process) {
    this.process = process;
  }

  public ProcessStatusDto actual(String actual) {
    this.actual = actual;
    return this;
  }

  /**
   * Get actual
   * @return actual
  */
  
  @Schema(name = "actual", required = false)
  public String getActual() {
    return actual;
  }

  public void setActual(String actual) {
    this.actual = actual;
  }

  public ProcessStatusDto expected(String expected) {
    this.expected = expected;
    return this;
  }

  /**
   * Get expected
   * @return expected
  */
  
  @Schema(name = "expected", required = false)
  public String getExpected() {
    return expected;
  }

  public void setExpected(String expected) {
    this.expected = expected;
  }

  public ProcessStatusDto status(StatusDto status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  @Valid 
  @Schema(name = "status", required = false)
  public StatusDto getStatus() {
    return status;
  }

  public void setStatus(StatusDto status) {
    this.status = status;
  }

  public ProcessStatusDto isHtml(Boolean isHtml) {
    this.isHtml = isHtml;
    return this;
  }

  /**
   * Get isHtml
   * @return isHtml
  */
  
  @Schema(name = "isHtml", required = false)
  public Boolean getIsHtml() {
    return isHtml;
  }

  public void setIsHtml(Boolean isHtml) {
    this.isHtml = isHtml;
  }

  public ProcessStatusDto notAffectStatus(Boolean notAffectStatus) {
    this.notAffectStatus = notAffectStatus;
    return this;
  }

  /**
   * Get notAffectStatus
   * @return notAffectStatus
  */
  
  @Schema(name = "notAffectStatus", required = false)
  public Boolean getNotAffectStatus() {
    return notAffectStatus;
  }

  public void setNotAffectStatus(Boolean notAffectStatus) {
    this.notAffectStatus = notAffectStatus;
  }

  public ProcessStatusDto attachments(List<AttachmentDto> attachments) {
    this.attachments = attachments;
    return this;
  }

  public ProcessStatusDto addAttachmentsItem(AttachmentDto attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

  /**
   * Get attachments
   * @return attachments
  */
  @Valid 
  @Schema(name = "attachments", required = false)
  public List<AttachmentDto> getAttachments() {
    return attachments;
  }

  public void setAttachments(List<AttachmentDto> attachments) {
    this.attachments = attachments;
  }

  public ProcessStatusDto isMandatory(Boolean isMandatory) {
    this.isMandatory = isMandatory;
    return this;
  }

  /**
   * Get isMandatory
   * @return isMandatory
  */
  
  @Schema(name = "isMandatory", required = false)
  public Boolean getIsMandatory() {
    return isMandatory;
  }

  public void setIsMandatory(Boolean isMandatory) {
    this.isMandatory = isMandatory;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessStatusDto processStatus = (ProcessStatusDto) o;
    return Objects.equals(this.process, processStatus.process) &&
        Objects.equals(this.actual, processStatus.actual) &&
        Objects.equals(this.expected, processStatus.expected) &&
        Objects.equals(this.status, processStatus.status) &&
        Objects.equals(this.isHtml, processStatus.isHtml) &&
        Objects.equals(this.notAffectStatus, processStatus.notAffectStatus) &&
        Objects.equals(this.attachments, processStatus.attachments) &&
        Objects.equals(this.isMandatory, processStatus.isMandatory);
  }

  @Override
  public int hashCode() {
    return Objects.hash(process, actual, expected, status, isHtml, notAffectStatus, attachments, isMandatory);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessStatusDto {\n");
    sb.append("    process: ").append(toIndentedString(process)).append("\n");
    sb.append("    actual: ").append(toIndentedString(actual)).append("\n");
    sb.append("    expected: ").append(toIndentedString(expected)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    isHtml: ").append(toIndentedString(isHtml)).append("\n");
    sb.append("    notAffectStatus: ").append(toIndentedString(notAffectStatus)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    isMandatory: ").append(toIndentedString(isMandatory)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

