package org.qubership.atp.environments.clients.api.healthcheck.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.clients.api.healthcheck.dto.ConnectionStatusDto;
import org.qubership.atp.environments.clients.api.healthcheck.dto.ProcessStatusDto;
import org.qubership.atp.environments.clients.api.healthcheck.dto.StatusDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * SystemStatusDto
 */

@JsonTypeName("SystemStatus")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-02T09:52:47.021408362Z[Etc/UTC]")
public class SystemStatusDto {

  @JsonProperty("systemId")
  private UUID systemId;

  @JsonProperty("name")
  private String name;

  @JsonProperty("processStatuses")
  @Valid
  private List<ProcessStatusDto> processStatuses = null;

  @JsonProperty("configurationStatuses")
  @Valid
  private List<ProcessStatusDto> configurationStatuses = null;

  @JsonProperty("connectionStatuses")
  @Valid
  private List<ConnectionStatusDto> connectionStatuses = null;

  @JsonProperty("status")
  private StatusDto status;

  public SystemStatusDto systemId(UUID systemId) {
    this.systemId = systemId;
    return this;
  }

  /**
   * Get systemId
   * @return systemId
  */
  @Valid 
  @Schema(name = "systemId", required = false)
  public UUID getSystemId() {
    return systemId;
  }

  public void setSystemId(UUID systemId) {
    this.systemId = systemId;
  }

  public SystemStatusDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SystemStatusDto processStatuses(List<ProcessStatusDto> processStatuses) {
    this.processStatuses = processStatuses;
    return this;
  }

  public SystemStatusDto addProcessStatusesItem(ProcessStatusDto processStatusesItem) {
    if (this.processStatuses == null) {
      this.processStatuses = new ArrayList<>();
    }
    this.processStatuses.add(processStatusesItem);
    return this;
  }

  /**
   * Get processStatuses
   * @return processStatuses
  */
  @Valid 
  @Schema(name = "processStatuses", required = false)
  public List<ProcessStatusDto> getProcessStatuses() {
    return processStatuses;
  }

  public void setProcessStatuses(List<ProcessStatusDto> processStatuses) {
    this.processStatuses = processStatuses;
  }

  public SystemStatusDto configurationStatuses(List<ProcessStatusDto> configurationStatuses) {
    this.configurationStatuses = configurationStatuses;
    return this;
  }

  public SystemStatusDto addConfigurationStatusesItem(ProcessStatusDto configurationStatusesItem) {
    if (this.configurationStatuses == null) {
      this.configurationStatuses = new ArrayList<>();
    }
    this.configurationStatuses.add(configurationStatusesItem);
    return this;
  }

  /**
   * Get configurationStatuses
   * @return configurationStatuses
  */
  @Valid 
  @Schema(name = "configurationStatuses", required = false)
  public List<ProcessStatusDto> getConfigurationStatuses() {
    return configurationStatuses;
  }

  public void setConfigurationStatuses(List<ProcessStatusDto> configurationStatuses) {
    this.configurationStatuses = configurationStatuses;
  }

  public SystemStatusDto connectionStatuses(List<ConnectionStatusDto> connectionStatuses) {
    this.connectionStatuses = connectionStatuses;
    return this;
  }

  public SystemStatusDto addConnectionStatusesItem(ConnectionStatusDto connectionStatusesItem) {
    if (this.connectionStatuses == null) {
      this.connectionStatuses = new ArrayList<>();
    }
    this.connectionStatuses.add(connectionStatusesItem);
    return this;
  }

  /**
   * Get connectionStatuses
   * @return connectionStatuses
  */
  @Valid 
  @Schema(name = "connectionStatuses", required = false)
  public List<ConnectionStatusDto> getConnectionStatuses() {
    return connectionStatuses;
  }

  public void setConnectionStatuses(List<ConnectionStatusDto> connectionStatuses) {
    this.connectionStatuses = connectionStatuses;
  }

  public SystemStatusDto status(StatusDto status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  @Valid 
  @Schema(name = "status", required = false)
  public StatusDto getStatus() {
    return status;
  }

  public void setStatus(StatusDto status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SystemStatusDto systemStatus = (SystemStatusDto) o;
    return Objects.equals(this.systemId, systemStatus.systemId) &&
        Objects.equals(this.name, systemStatus.name) &&
        Objects.equals(this.processStatuses, systemStatus.processStatuses) &&
        Objects.equals(this.configurationStatuses, systemStatus.configurationStatuses) &&
        Objects.equals(this.connectionStatuses, systemStatus.connectionStatuses) &&
        Objects.equals(this.status, systemStatus.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(systemId, name, processStatuses, configurationStatuses, connectionStatuses, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SystemStatusDto {\n");
    sb.append("    systemId: ").append(toIndentedString(systemId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    processStatuses: ").append(toIndentedString(processStatuses)).append("\n");
    sb.append("    configurationStatuses: ").append(toIndentedString(configurationStatuses)).append("\n");
    sb.append("    connectionStatuses: ").append(toIndentedString(connectionStatuses)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

