/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import org.qubership.atp.environments.service.rest.server.dto.generated.CompareEntityResponseDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.HistoryItemResponseDtoGenerated;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-02T09:52:44.523928105Z[Etc/UTC]")
@Validated
@Tag(name = "HistoryController", description = "Model History API")
public interface HistoryControllerApi {

    /**
     * GET /api/history/{projectId}/{itemType}/{id} : finds all changes history for defined object
     *
     * @param projectId  (required)
     * @param itemType  (required)
     * @param id  (required)
     * @param offset  (optional, default to 0)
     * @param limit  (optional, default to 10)
     * @return OK (status code 200)
     *         or History for Entity type &#x3D; &#39;\&quot; + itemType + \&quot;&#39; is not supported (status code 400)
     *         or Entity Id not found (status code 404)
     */
    @Operation(
        operationId = "getAllHistory",
        summary = "finds all changes history for defined object",
        tags = { "history-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = HistoryItemResponseDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "400", description = "History for Entity type = '\" + itemType + \"' is not supported"),
            @ApiResponse(responseCode = "404", description = "Entity Id not found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/history/{projectId}/{itemType}/{id}",
        produces = { "application/json" }
    )
    ResponseEntity<HistoryItemResponseDtoGenerated> getAllHistory(
        @Parameter(name = "projectId", description = "", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "itemType", description = "", required = true) @PathVariable("itemType") String itemType,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "offset", description = "") @Valid @RequestParam(value = "offset", required = false, defaultValue = "0") Integer offset,
        @Parameter(name = "limit", description = "") @Valid @RequestParam(value = "limit", required = false, defaultValue = "10") Integer limit
    );


    /**
     * GET /api/history/version/{projectId}/{itemType}/{id}/revision/{revisionIds} : finds all entity&#39;s states for provided version ids
     *
     * @param projectId  (required)
     * @param itemType  (required)
     * @param id  (required)
     * @param revisionIds  (required)
     * @return OK (status code 200)
     *         or Versioning for Entity type &#x3D; &#39;\&quot; + itemType + \&quot;&#39; is not supported (status code 400)
     *         or Entity Id not found (status code 404)
     */
    @Operation(
        operationId = "getEntitiesByVersion",
        summary = "finds all entity's states for provided version ids",
        tags = { "history-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CompareEntityResponseDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "400", description = "Versioning for Entity type = '\" + itemType + \"' is not supported"),
            @ApiResponse(responseCode = "404", description = "Entity Id not found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/history/version/{projectId}/{itemType}/{id}/revision/{revisionIds}",
        produces = { "application/json" }
    )
    ResponseEntity<List<CompareEntityResponseDtoGenerated>> getEntitiesByVersion(
        @Parameter(name = "projectId", description = "", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "itemType", description = "", required = true) @PathVariable("itemType") String itemType,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "revisionIds", description = "", required = true) @PathVariable("revisionIds") List<String> revisionIds
    );


    /**
     * POST /api/history/restore/{projectId}/{itemType}/{id}/revision/{revisionId} : Restore the state of the provided entity to defined revision
     *
     * @param projectId  (required)
     * @param itemType  (required)
     * @param id  (required)
     * @param revisionId  (required)
     * @return Revision was restored successfully (status code 200)
     *         or Restore for Entity type &#x3D; &#39;\&quot; + itemType + \&quot;&#39; is not supported (status code 400)
     *         or Forbidden (status code 403)
     *         or Entity Id not found (status code 404)
     *         or Revision was not restored. Reference to the one of the systems is invalid. (status code 500)
     */
    @Operation(
        operationId = "restoreToRevision",
        summary = "Restore the state of the provided entity to defined revision",
        tags = { "history-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Revision was restored successfully"),
            @ApiResponse(responseCode = "400", description = "Restore for Entity type = '\" + itemType + \"' is not supported"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Entity Id not found"),
            @ApiResponse(responseCode = "500", description = "Revision was not restored. Reference to the one of the systems is invalid.")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/history/restore/{projectId}/{itemType}/{id}/revision/{revisionId}"
    )
    ResponseEntity<Void> restoreToRevision(
        @Parameter(name = "projectId", description = "", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "itemType", description = "", required = true) @PathVariable("itemType") String itemType,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "revisionId", description = "", required = true) @PathVariable("revisionId") Integer revisionId
    );

}
