/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import org.qubership.atp.environments.service.rest.server.dto.generated.ConnectionFullVer2ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentNameViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentResDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.GroupedByTagEnvironmentResponseDtoGenerated;
import java.util.List;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectFullVer1ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectFullVer2ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectImplDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectNameViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectSearchRequestDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.StatusDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemEnvironmentsViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer2ViewDtoGenerated;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-02T09:52:46.006035466Z[Etc/UTC]")
@Validated
@Tag(name = "ProjectController", description = "Project Controller")
public interface ProjectControllerApi {

    /**
     * POST /api/projects/{projectId}/copy : copy
     *
     * @param projectId projectId (required)
     * @param projectDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copy",
        summary = "copy",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/projects/{projectId}/copy",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ProjectDtoGenerated> copy(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "ProjectDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) ProjectDtoDtoGenerated projectDtoDtoGenerated
    );


    /**
     * POST /api/projects/{projectId}/environments : createEnvironment
     *
     * @param projectId projectId (required)
     * @param environmentDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createEnvironment",
        summary = "createEnvironment",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/projects/{projectId}/environments",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<EnvironmentResDtoGenerated> createEnvironment(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "EnvironmentDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) EnvironmentDtoDtoGenerated environmentDtoDtoGenerated
    );


    /**
     * POST /api/projects : create
     *
     * @param projectImplDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createProject",
        summary = "create",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/projects",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ProjectDtoGenerated> createProject(
        @Parameter(name = "ProjectImplDtoGenerated", description = "") @Valid @RequestBody(required = false) ProjectImplDtoGenerated projectImplDtoGenerated
    );


    /**
     * POST /api/projects/{projectId}/tools : createTool
     *
     * @param projectId projectId (required)
     * @param environmentDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createTool",
        summary = "createTool",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/projects/{projectId}/tools",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<EnvironmentResDtoGenerated> createTool(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "EnvironmentDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) EnvironmentDtoDtoGenerated environmentDtoDtoGenerated
    );


    /**
     * DELETE /api/projects/{projectId} : delete
     *
     * @param projectId projectId (required)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteProject",
        summary = "delete",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/api/projects/{projectId}"
    )
    ResponseEntity<Void> deleteProject(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/projects/{projectId}/environments/all : getAllEnvironments
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllEnvironments",
        summary = "getAllEnvironments",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/all",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentResDtoGenerated>> getAllEnvironments(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects : getAll
     *
     * @param host host (optional)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllProjects",
        summary = "getAll",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectFullVer2ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects",
        produces = { "application/json" }
    )
    ResponseEntity<List<ProjectFullVer2ViewDtoGenerated>> getAllProjects(
        @Parameter(name = "host", description = "host") @Valid @RequestParam(value = "host", required = false) String host,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/short : getAllShort
     *
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllShort",
        summary = "getAllShort",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectNameViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<ProjectNameViewDtoGenerated>> getAllShort(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/systems/short : Endpoint for getting list of systems on project by projectId
     *
     * @param projectId Project id for getting system (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllShortSystemsOnProject",
        summary = "Endpoint for getting list of systems on project by projectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemEnvironmentsViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/systems/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemEnvironmentsViewDtoGenerated>> getAllShortSystemsOnProject(
        @Parameter(name = "projectId", description = "Project id for getting system", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/projects/shortWithAccess : getAllShortWithAccess
     *
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllShortWithUserAccess",
        summary = "getAllShortWithAccess",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectNameViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/shortWithAccess",
        produces = { "application/json" }
    )
    ResponseEntity<List<ProjectNameViewDtoGenerated>> getAllShortWithUserAccess(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/connections : getConnections
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConnections",
        summary = "getConnections",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionFullVer2ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/connections",
        produces = { "application/json" }
    )
    ResponseEntity<List<ConnectionFullVer2ViewDtoGenerated>> getConnections(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/connections/name : getConnectionsName
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConnectionsName",
        summary = "getConnectionsName",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/connections/name",
        produces = { "application/json" }
    )
    ResponseEntity<List<String>> getConnectionsName(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/projects/{projectId}/environments : getEnvironments
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironments",
        summary = "getEnvironments",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentResDtoGenerated>> getEnvironments(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/groupedByTags : getEnvironmentsGroupedByTags
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironmentsGroupedByTags",
        summary = "getEnvironmentsGroupedByTags",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GroupedByTagEnvironmentResponseDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/groupedByTags",
        produces = { "application/json" }
    )
    ResponseEntity<List<GroupedByTagEnvironmentResponseDtoGenerated>> getEnvironmentsGroupedByTags(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/short : getEnvironmentsShort
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironmentsShort",
        summary = "getEnvironmentsShort",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentNameViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentNameViewDtoGenerated>> getEnvironmentsShort(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/projects/{projectId} : getProject
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProject",
        summary = "getProject",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectFullVer1ViewDtoGenerated> getProject(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/systems : getSystems
     *
     * @param projectId projectId (required)
     * @param category category (optional)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjectSystems",
        summary = "getSystems",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer2ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/systems",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer2ViewDtoGenerated>> getProjectSystems(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "category", description = "category") @Valid @RequestParam(value = "category", required = false) String category,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/{environmentIds} : getProjectWithSpecifiedEnvironments
     *
     * @param projectId projectId (required)
     * @param environmentIds environmentIds (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjectWithSpecifiedEnvironments",
        summary = "getProjectWithSpecifiedEnvironments",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/{environmentIds}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectFullVer1ViewDtoGenerated> getProjectWithSpecifiedEnvironments(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "environmentIds", description = "environmentIds", required = true) @PathVariable("environmentIds") List<UUID> environmentIds,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * POST /api/projects/search : getProjectsByRequest
     *
     * @param full full (optional)
     * @param projectSearchRequestDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjectsByRequest",
        summary = "getProjectsByRequest",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectFullVer2ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/projects/search",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<ProjectFullVer2ViewDtoGenerated>> getProjectsByRequest(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full,
        @Parameter(name = "ProjectSearchRequestDtoGenerated", description = "") @Valid @RequestBody(required = false) ProjectSearchRequestDtoGenerated projectSearchRequestDtoGenerated
    );


    /**
     * GET /api/projects/short/{projectId} : getShortProject
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getShortProject",
        summary = "getShortProject",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/short/{projectId}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectFullVer1ViewDtoGenerated> getShortProject(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/short/name/{projectName} : getShortProjectByName
     *
     * @param projectName projectName (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getShortProjectByName",
        summary = "getShortProjectByName",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/short/name/{projectName}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectFullVer1ViewDtoGenerated> getShortProjectByName(
        @Parameter(name = "projectName", description = "projectName", required = true) @PathVariable("projectName") String projectName,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/systems/name : getSystemsName
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getSystemsName",
        summary = "getSystemsName",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/systems/name",
        produces = { "application/json" }
    )
    ResponseEntity<List<String>> getSystemsName(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/projects/{projectId}/temporary/environments : getTemporaryEnvironments
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTemporaryEnvironments",
        summary = "getTemporaryEnvironments",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/temporary/environments",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentResDtoGenerated>> getTemporaryEnvironments(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/tools : getTools
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTools",
        summary = "getTools",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/tools",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentResDtoGenerated>> getTools(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/tools/short : getToolsShort
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getToolsShort",
        summary = "getToolsShort",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentNameViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/tools/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentNameViewDtoGenerated>> getToolsShort(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * PUT /api/projects : update
     *
     * @param projectDtoDtoGenerated  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateProject",
        summary = "update",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/projects",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> updateProject(
        @Parameter(name = "ProjectDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) ProjectDtoDtoGenerated projectDtoDtoGenerated
    );


    /**
     * PUT /api/projects/{projectId}/systems/status : updateSystemStatuses
     *
     * @param projectId projectId (required)
     * @param statusDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateSystemStatuses",
        summary = "updateSystemStatuses",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/projects/{projectId}/systems/status",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<Object>> updateSystemStatuses(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "StatusDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) List<StatusDtoDtoGenerated> statusDtoDtoGenerated
    );

}
