/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer1ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer2ViewDtoGenerated;
import java.util.UUID;
import org.qubership.atp.environments.service.rest.server.dto.generated.ValidateTaToolsRequestDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ValidateTaToolsResponseDtoGenerated;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-02T09:52:46.776740422Z[Etc/UTC]")
@Validated
@Tag(name = "ToolController", description = "Tool Controller")
public interface ToolControllerApi {

    /**
     * POST /api/tools/{toolGroupId}/copy : copy
     *
     * @param toolGroupId toolGroupId (required)
     * @param environmentDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copyTool",
        summary = "copy",
        tags = { "tool-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/tools/{toolGroupId}/copy",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<EnvironmentDtoGenerated> copyTool(
        @Parameter(name = "toolGroupId", description = "toolGroupId", required = true) @PathVariable("toolGroupId") UUID toolGroupId,
        @Parameter(name = "EnvironmentDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) EnvironmentDtoDtoGenerated environmentDtoDtoGenerated
    );


    /**
     * POST /api/tools : create
     *
     * @param environmentDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createTool",
        summary = "create",
        tags = { "tool-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/tools",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<EnvironmentDtoGenerated> createTool(
        @Parameter(name = "EnvironmentDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) EnvironmentDtoDtoGenerated environmentDtoDtoGenerated
    );


    /**
     * DELETE /api/tools/{toolGroupId} : delete
     *
     * @param toolGroupId toolGroupId (required)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteTool",
        summary = "delete",
        tags = { "tool-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/api/tools/{toolGroupId}"
    )
    ResponseEntity<Void> deleteTool(
        @Parameter(name = "toolGroupId", description = "toolGroupId", required = true) @PathVariable("toolGroupId") UUID toolGroupId
    );


    /**
     * GET /api/tools : getAll
     *
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAll",
        summary = "getAll",
        tags = { "tool-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/tools",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentDtoGenerated>> getAll(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/tools/{toolGroupId} : getEnvironment
     *
     * @param toolGroupId toolGroupId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironment",
        summary = "getEnvironment",
        tags = { "tool-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/tools/{toolGroupId}",
        produces = { "application/json" }
    )
    ResponseEntity<EnvironmentDtoGenerated> getEnvironment(
        @Parameter(name = "toolGroupId", description = "toolGroupId", required = true) @PathVariable("toolGroupId") UUID toolGroupId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/v2/tools/{toolGroupId}/systems : getSystemV2
     *
     * @param toolGroupId toolGroupId (required)
     * @param systemType system_type (optional)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getSystemV2",
        summary = "getSystemV2",
        tags = { "tool-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer2ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v2/tools/{toolGroupId}/systems",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer2ViewDtoGenerated>> getSystemV2(
        @Parameter(name = "toolGroupId", description = "toolGroupId", required = true) @PathVariable("toolGroupId") UUID toolGroupId,
        @Parameter(name = "system_type", description = "system_type") @Valid @RequestParam(value = "system_type", required = false) String systemType,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/tools/{toolGroupId}/systems : getSystems
     *
     * @param toolGroupId toolGroupId (required)
     * @param systemType system_type (optional)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getToolSystems",
        summary = "getSystems",
        tags = { "tool-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/tools/{toolGroupId}/systems",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer1ViewDtoGenerated>> getToolSystems(
        @Parameter(name = "toolGroupId", description = "toolGroupId", required = true) @PathVariable("toolGroupId") UUID toolGroupId,
        @Parameter(name = "system_type", description = "system_type") @Valid @RequestParam(value = "system_type", required = false) String systemType,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * PUT /api/tools : update
     *
     * @param environmentDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateTool",
        summary = "update",
        tags = { "tool-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/tools",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> updateTool(
        @Parameter(name = "EnvironmentDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) EnvironmentDtoDtoGenerated environmentDtoDtoGenerated
    );


    /**
     * GET /api/tools/{toolGroupId}/version : updateVersion
     *
     * @param toolGroupId toolGroupId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateVersion",
        summary = "updateVersion",
        tags = { "tool-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/tools/{toolGroupId}/version",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemDtoGenerated>> updateVersion(
        @Parameter(name = "toolGroupId", description = "toolGroupId", required = true) @PathVariable("toolGroupId") UUID toolGroupId
    );


    /**
     * POST /api/tools/validate : validateTaTools
     *
     * @param validateTaToolsRequestDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "validateTaTools",
        summary = "validateTaTools",
        tags = { "tool-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ValidateTaToolsResponseDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/tools/validate",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ValidateTaToolsResponseDtoGenerated> validateTaTools(
        @Parameter(name = "ValidateTaToolsRequestDtoGenerated", description = "") @Valid @RequestBody(required = false) ValidateTaToolsRequestDtoGenerated validateTaToolsRequestDtoGenerated
    );

}
