/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.environments.validating.factories;

import java.util.Map;

import org.qubership.atp.environments.validating.strategies.ValidationStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidationStrategyFactory {

    public static final String ITF_LITE = "itfLite";

    private final Map<String, ValidationStrategy> strategyMap;

    @Autowired
    public ValidationStrategyFactory(Map<String, ValidationStrategy> strategyMap) {
        this.strategyMap = strategyMap;
    }

    /**
     * Get strategy by type.
     *
     * @param strategyType name of strategy
     * @return ValidationStrategy
     */
    public ValidationStrategy createStrategy(String strategyType) {
        ValidationStrategy strategy = strategyMap.get(strategyType);
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Invalid validation strategy type %s", strategyType));
        }
        return strategy;
    }
}
