/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.cache;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.qubership.atp.environments.errorhandling.hazelcastcache.EnvironmentHazelcastCacheIllegalValueTypeException;
import org.qubership.atp.environments.errorhandling.hazelcastcache.EnvironmentHazelcastCacheLookupTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class EnvironmentHazelcastCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentHazelcastCache.class);
    private int ttl;
    private TimeUnit timeUnit;
    private static final DataSerializable NULL = new NullDataSerializable();
    private final IMap<Object, Object> map;
    private long readTimeout;

    public EnvironmentHazelcastCache(IMap<Object, Object> map, int ttl, TimeUnit timeUnit) {
        this.ttl = ttl;
        this.timeUnit = timeUnit;
        this.map = map;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getName() {
        return this.map.getName();
    }

    public IMap<Object, Object> getNativeCache() {
        return this.map;
    }

    public Cache.ValueWrapper get(Object key) {
        if (key == null) {
            return null;
        }
        Object value = this.lookup(key);
        return value != null ? new SimpleValueWrapper(this.fromStoreValue(value)) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.fromStoreValue(this.lookup(key));
        if (type != null && value != null && !type.isInstance(value)) {
            log.error("Cached value '{}' is not of required type: {}", value, (Object)type.getName());
            throw new EnvironmentHazelcastCacheIllegalValueTypeException();
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.lookup(key);
        if (value != null) {
            return (T)this.fromStoreValue(value);
        }
        this.map.lock(key);
        try {
            value = this.lookup(key);
            if (value != null) {
                Object object = this.fromStoreValue(value);
                return (T)object;
            }
            T t = this.loadValue(key, valueLoader);
            return t;
        }
        finally {
            this.map.unlock(key);
        }
    }

    private <T> T loadValue(Object key, Callable<T> valueLoader) {
        T value;
        try {
            value = valueLoader.call();
        }
        catch (Exception ex) {
            throw ValueRetrievalExceptionResolver.resolveException(key, valueLoader, ex);
        }
        this.put(key, value);
        return value;
    }

    public void put(Object key, Object value) {
        if (key != null) {
            this.map.put(key, this.toStoreValue(value), (long)this.ttl, this.timeUnit);
        }
    }

    protected Object toStoreValue(Object value) {
        if (value == null) {
            return NULL;
        }
        return value;
    }

    protected Object fromStoreValue(Object value) {
        if (NULL.equals(value)) {
            return null;
        }
        return value;
    }

    public void evict(Object key) {
        if (key != null) {
            this.map.delete(key);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object result = this.map.putIfAbsent(key, this.toStoreValue(value), (long)this.ttl, this.timeUnit);
        return result != null ? new SimpleValueWrapper(this.fromStoreValue(result)) : null;
    }

    private Object lookup(Object key) {
        if (this.readTimeout > 0L) {
            try {
                return this.map.getAsync(key).toCompletableFuture().get(this.readTimeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                log.error("The lookup cache operation for key '{}' exceeded the maximum time allowed", key, (Object)e);
                throw new EnvironmentHazelcastCacheLookupTimeoutException();
            }
            catch (InterruptedException e) {
                log.error("Interrupted exception during hazelcast cache lookup operation for key '{}'", key, (Object)e);
                Thread.currentThread().interrupt();
                throw ExceptionUtil.rethrow((Throwable)e);
            }
            catch (Exception e) {
                log.error("Exception during hazelcast cache lookup operation for key '{}'", key, (Object)e);
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        return this.map.get(key);
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    private static class ValueRetrievalExceptionResolver {
        private ValueRetrievalExceptionResolver() {
        }

        static RuntimeException resolveException(Object key, Callable<?> valueLoader, Throwable ex) {
            return new Cache.ValueRetrievalException(key, valueLoader, ex);
        }
    }

    static final class NullDataSerializable
    implements DataSerializable {
        NullDataSerializable() {
        }

        public void writeData(ObjectDataOutput out) {
        }

        public void readData(ObjectDataInput in) {
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return 0;
        }
    }
}

