/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.config;

import com.hazelcast.core.HazelcastInstance;
import java.util.HashMap;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.qubership.atp.environments.config.BeanAwareSpringLiquibaseConfiguration;
import org.qubership.atp.environments.config.HazelcastConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LiquibaseProperties.class})
public class SpringLiquibaseConfig {
    private static final Logger log = LoggerFactory.getLogger(SpringLiquibaseConfig.class);
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${service.entities.migration.enabled:false}")
    private String migrationEnabled;
    private DataSource dataSource;
    private LiquibaseProperties properties;

    public SpringLiquibaseConfig(DataSource dataSource, LiquibaseProperties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    @Bean
    public SpringLiquibase liquibase(@Autowired(required=false) @Qualifier(value="hazelcastClient") HazelcastInstance hazelcastClient) {
        HazelcastConfig.clearHazelcastMap(hazelcastClient);
        BeanAwareSpringLiquibaseConfiguration liquibase = new BeanAwareSpringLiquibaseConfiguration();
        liquibase.setDataSource(this.dataSource);
        liquibase.setChangeLog(this.properties.getChangeLog());
        liquibase.setContexts(this.properties.getContexts());
        liquibase.setDefaultSchema(this.properties.getDefaultSchema());
        liquibase.setDropFirst(this.properties.isDropFirst());
        liquibase.setShouldRun(this.properties.isEnabled());
        liquibase.setLabels(this.properties.getLabels());
        HashMap<String, String> props = this.properties.getParameters();
        if (props == null) {
            props = new HashMap<String, String>();
        }
        props.put("spring.application.name", this.serviceName);
        props.put("service.entities.migration.enabled", this.migrationEnabled);
        liquibase.setChangeLogParameters(props);
        liquibase.setRollbackFile(this.properties.getRollbackFile());
        return liquibase;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getMigrationEnabled() {
        return this.migrationEnabled;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public LiquibaseProperties getProperties() {
        return this.properties;
    }
}

